/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.census;

import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.ClientInterceptor;
import io.grpc.ExperimentalApi;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ServerBuilder;
import io.grpc.ServerStreamTracer;
import io.grpc.census.CensusStatsModule;
import io.grpc.census.CensusTracingModule;
import io.opencensus.trace.Tracing;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/12178")
public final class GrpcCensus {
    private final boolean statsEnabled;
    private final boolean tracingEnabled;
    private static final Supplier<Stopwatch> STOPWATCH_SUPPLIER = new Supplier<Stopwatch>(){

        public Stopwatch get() {
            return Stopwatch.createUnstarted();
        }
    };

    private GrpcCensus(Builder builder) {
        this.statsEnabled = builder.statsEnabled;
        this.tracingEnabled = builder.tracingEnabled;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public <T extends ServerBuilder<T>> T configureServerBuilder(T serverBuilder) {
        if (this.statsEnabled) {
            serverBuilder.addStreamTracerFactory(GrpcCensus.newServerStatsStreamTracerFactory());
        }
        if (this.tracingEnabled) {
            serverBuilder.addStreamTracerFactory(GrpcCensus.newServerTracingStreamTracerFactory());
        }
        return serverBuilder;
    }

    public <T extends ManagedChannelBuilder<T>> T configureChannelBuilder(T channelBuilder) {
        if (this.statsEnabled) {
            channelBuilder.intercept(new ClientInterceptor[]{GrpcCensus.newClientStatsInterceptor()});
        }
        if (this.tracingEnabled) {
            channelBuilder.intercept(new ClientInterceptor[]{GrpcCensus.newClientTracingInterceptor()});
        }
        return channelBuilder;
    }

    private static ClientInterceptor newClientStatsInterceptor() {
        CensusStatsModule censusStats = new CensusStatsModule(STOPWATCH_SUPPLIER, true, true, true, false, true);
        return censusStats.getClientInterceptor();
    }

    private static ClientInterceptor newClientTracingInterceptor() {
        CensusTracingModule censusTracing = new CensusTracingModule(Tracing.getTracer(), Tracing.getPropagationComponent().getBinaryFormat());
        return censusTracing.getClientInterceptor();
    }

    private static ServerStreamTracer.Factory newServerStatsStreamTracerFactory() {
        CensusStatsModule censusStats = new CensusStatsModule(STOPWATCH_SUPPLIER, true, true, true, false, true);
        return censusStats.getServerTracerFactory();
    }

    private static ServerStreamTracer.Factory newServerTracingStreamTracerFactory() {
        CensusTracingModule censusTracing = new CensusTracingModule(Tracing.getTracer(), Tracing.getPropagationComponent().getBinaryFormat());
        return censusTracing.getServerTracerFactory();
    }

    public static final class Builder {
        private boolean statsEnabled = true;
        private boolean tracingEnabled = true;

        private Builder() {
        }

        public Builder disableStats() {
            this.statsEnabled = false;
            return this;
        }

        public Builder disableTracing() {
            this.tracingEnabled = false;
            return this;
        }

        public GrpcCensus build() {
            return new GrpcCensus(this);
        }
    }
}

