/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.android;

import android.net.LocalSocketAddress;
import io.grpc.ChannelCredentials;
import io.grpc.ExperimentalApi;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannelBuilder;
import io.grpc.android.UdsSocketFactory;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import javax.net.SocketFactory;

@ExperimentalApi(value="A stopgap. Not intended to be stabilized")
public final class UdsChannelBuilder {
    @Nullable
    private static final Class<? extends ManagedChannelBuilder> OKHTTP_CHANNEL_BUILDER_CLASS = UdsChannelBuilder.findOkHttp();

    private static Class<? extends ManagedChannelBuilder> findOkHttp() {
        try {
            return Class.forName("io.grpc.okhttp.OkHttpChannelBuilder").asSubclass(ManagedChannelBuilder.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static ManagedChannelBuilder<?> forPath(String path, LocalSocketAddress.Namespace namespace) {
        if (OKHTTP_CHANNEL_BUILDER_CLASS == null) {
            throw new UnsupportedOperationException("OkHttpChannelBuilder not found on the classpath");
        }
        try {
            Object o = OKHTTP_CHANNEL_BUILDER_CLASS.getMethod("forTarget", String.class, ChannelCredentials.class).invoke(null, "dns:///127.0.0.1", InsecureChannelCredentials.create());
            ManagedChannelBuilder builder = OKHTTP_CHANNEL_BUILDER_CLASS.cast(o);
            OKHTTP_CHANNEL_BUILDER_CLASS.getMethod("socketFactory", SocketFactory.class).invoke((Object)builder, new UdsSocketFactory(path, namespace));
            return builder;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to create OkHttpChannelBuilder", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to create OkHttpChannelBuilder", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to create OkHttpChannelBuilder", e);
        }
    }

    private UdsChannelBuilder() {
    }
}

