/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.okhttp;

import com.squareup.okhttp.internal.spdy.Header;
import io.grpc.Metadata;
import io.grpc.transport.TransportFrameUtil;
import java.util.List;

class Utils {
    static final int DEFAULT_WINDOW_SIZE = 65535;
    static final int CONNECTION_STREAM_ID = 0;

    public static Metadata.Headers convertHeaders(List<Header> http2Headers) {
        return new Metadata.Headers(Utils.convertHeadersToArray(http2Headers));
    }

    public static Metadata.Trailers convertTrailers(List<Header> http2Headers) {
        return new Metadata.Trailers(Utils.convertHeadersToArray(http2Headers));
    }

    private static byte[][] convertHeadersToArray(List<Header> http2Headers) {
        byte[][] headerValues = new byte[http2Headers.size() * 2][];
        int i = 0;
        for (Header header : http2Headers) {
            headerValues[i++] = header.name.toByteArray();
            headerValues[i++] = header.value.toByteArray();
        }
        return TransportFrameUtil.toRawSerializedHeaders(headerValues);
    }

    private Utils() {
    }
}

