/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import io.grpc.Call;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingCall;
import io.grpc.ForwardingCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.stub.AbstractStub;
import java.util.concurrent.atomic.AtomicReference;

public class MetadataUtils {
    public static <T extends AbstractStub> T attachHeaders(T stub, Metadata.Headers extraHeaders) {
        return (T)stub.configureNewStub().addInterceptor(MetadataUtils.newAttachHeadersInterceptor(extraHeaders)).build();
    }

    public static ClientInterceptor newAttachHeadersInterceptor(final Metadata.Headers extraHeaders) {
        return new ClientInterceptor(){

            public <ReqT, RespT> Call<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, Channel next) {
                return new ForwardingCall.SimpleForwardingCall<ReqT, RespT>(next.newCall(method)){

                    @Override
                    public void start(Call.Listener<RespT> responseListener, Metadata.Headers headers) {
                        headers.merge(extraHeaders);
                        super.start(responseListener, headers);
                    }
                };
            }
        };
    }

    public static <T extends AbstractStub> T captureMetadata(T stub, AtomicReference<Metadata.Headers> headersCapture, AtomicReference<Metadata.Trailers> trailersCapture) {
        return (T)stub.configureNewStub().addInterceptor(MetadataUtils.newCaptureMetadataInterceptor(headersCapture, trailersCapture)).build();
    }

    public static ClientInterceptor newCaptureMetadataInterceptor(final AtomicReference<Metadata.Headers> headersCapture, final AtomicReference<Metadata.Trailers> trailersCapture) {
        return new ClientInterceptor(){

            public <ReqT, RespT> Call<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, Channel next) {
                return new ForwardingCall.SimpleForwardingCall<ReqT, RespT>(next.newCall(method)){

                    @Override
                    public void start(Call.Listener<RespT> responseListener, Metadata.Headers headers) {
                        headersCapture.set(null);
                        trailersCapture.set(null);
                        super.start(new ForwardingCallListener.SimpleForwardingCallListener<RespT>(responseListener){

                            @Override
                            public void onHeaders(Metadata.Headers headers) {
                                headersCapture.set(headers);
                                super.onHeaders(headers);
                            }

                            @Override
                            public void onClose(Status status, Metadata.Trailers trailers) {
                                trailersCapture.set(trailers);
                                super.onClose(status, trailers);
                            }
                        }, headers);
                    }
                };
            }
        };
    }
}

