/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import com.google.common.collect.Maps;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.MethodDescriptor;
import io.grpc.stub.AbstractServiceDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbstractStub<S extends AbstractStub<?, ?>, C extends AbstractServiceDescriptor<C>> {
    protected final Channel channel;
    protected final C config;

    protected AbstractStub(Channel channel, C config) {
        this.channel = channel;
        this.config = config;
    }

    protected C getServiceDescriptor() {
        return this.config;
    }

    public StubConfigBuilder configureNewStub() {
        return new StubConfigBuilder();
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected abstract S build(Channel var1, C var2);

    public class StubConfigBuilder {
        private final Map<String, MethodDescriptor<?, ?>> methodMap;
        private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
        private Channel stubChannel;

        private StubConfigBuilder() {
            this.stubChannel = AbstractStub.this.channel;
            this.methodMap = Maps.newHashMapWithExpectedSize((int)((AbstractServiceDescriptor)AbstractStub.this.config).methods().size());
            for (MethodDescriptor method : ((AbstractServiceDescriptor)AbstractStub.this.config).methods()) {
                this.methodMap.put(method.getName(), method);
            }
        }

        public StubConfigBuilder setTimeout(long timeout, TimeUnit unit) {
            for (Map.Entry<String, MethodDescriptor<?, ?>> entry : this.methodMap.entrySet()) {
                entry.setValue(entry.getValue().withTimeout(timeout, unit));
            }
            return this;
        }

        public StubConfigBuilder setChannel(Channel channel) {
            this.stubChannel = channel;
            return this;
        }

        public StubConfigBuilder addInterceptor(ClientInterceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public S build() {
            return AbstractStub.this.build(ClientInterceptors.intercept(this.stubChannel, this.interceptors), ((AbstractServiceDescriptor)AbstractStub.this.config).build(this.methodMap));
        }
    }
}

