/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.services.upgrader;

import io.gravitee.common.component.LifecycleComponent;
import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.upgrader.UpgradeRecord;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderRepository;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class UpgraderServiceImpl
extends AbstractService<UpgraderServiceImpl>
implements LifecycleComponent<UpgraderServiceImpl> {
    @Autowired
    @Lazy
    private UpgraderRepository upgraderRepository;
    @Value(value="${upgrade.mode:false}")
    private boolean upgradeMode;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgraderServiceImpl.class);

    protected String name() {
        return "Upgrader service";
    }

    protected void doStart() throws Exception {
        super.doStart();
        Map upgraderBeans = this.applicationContext.getBeansOfType(Upgrader.class);
        AtomicBoolean stopUpgrade = new AtomicBoolean(false);
        upgraderBeans.values().stream().sorted(Comparator.comparing(Upgrader::getOrder)).takeWhile(upgrader -> !stopUpgrade.get()).forEach(upgrader -> {
            String name = upgrader.getClass().getSimpleName();
            try {
                UpgradeRecord upgradeRecord = (UpgradeRecord)this.upgraderRepository.findById(upgrader.getClass().getName()).blockingGet();
                if (upgradeRecord != null) {
                    LOGGER.info("{} is already applied. it will be ignored.", (Object)name);
                } else {
                    LOGGER.info("Apply {} ...", (Object)name);
                    if (upgrader.upgrade()) {
                        this.upgraderRepository.create(new UpgradeRecord(upgrader.getClass().getName(), new Date())).blockingGet();
                    } else {
                        stopUpgrade.set(true);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to apply {}. Error: ", (Object)name, (Object)e);
            }
        });
        if (this.upgradeMode || stopUpgrade.get()) {
            Node node = (Node)this.applicationContext.getBean(Node.class);
            node.preStop();
            node.stop();
            node.postStop();
            if (stopUpgrade.get()) {
                LOGGER.error("Stopping because one of the upgrades could not be performed");
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
    }
}

