/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.plugins.service.impl;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.plugins.service.ServiceManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManagerImpl
extends AbstractService
implements ServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceManagerImpl.class);
    private final List<AbstractService> services = new ArrayList<AbstractService>();

    @Override
    public void register(AbstractService service) {
        this.services.add(service);
    }

    protected void doStart() throws Exception {
        super.doStart();
        List orderedServices = this.services.stream().sorted(Comparator.comparing(AbstractService::getOrder)).collect(Collectors.toList());
        for (AbstractService service : orderedServices) {
            try {
                service.preStart();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error while pre-starting service", (Throwable)ex);
            }
        }
        for (AbstractService service : orderedServices) {
            try {
                service.start();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error while starting service", (Throwable)ex);
            }
        }
        for (AbstractService service : orderedServices) {
            try {
                service.postStart();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error while post-starting service", (Throwable)ex);
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        List orderedServices = this.services.stream().sorted(Comparator.comparing(AbstractService::getOrder, Comparator.reverseOrder())).collect(Collectors.toList());
        for (AbstractService service : orderedServices) {
            try {
                service.preStop();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error while pre-stopping service", (Throwable)ex);
            }
        }
        for (AbstractService service : orderedServices) {
            try {
                service.stop();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error while stopping service", (Throwable)ex);
            }
        }
        for (AbstractService service : orderedServices) {
            try {
                service.postStop();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error while post-stopping service", (Throwable)ex);
            }
        }
    }

    protected String name() {
        return "Plugins - Services Manager";
    }
}

