/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.standalone.healthcheck;

import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.Result;
import io.gravitee.rest.api.standalone.vertx.VertxCompletableFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class GraviteeApisProbe
implements Probe {
    @Value(value="${jetty.port:8083}")
    private int port;
    @Value(value="${jetty.host:localhost}")
    private String host;
    @Autowired
    private Vertx vertx;

    public String id() {
        return "gravitee-apis";
    }

    public CompletableFuture<Result> check() {
        Future future = Future.future();
        NetClientOptions options = new NetClientOptions().setConnectTimeout(500);
        NetClient client = this.vertx.createNetClient(options);
        client.connect(this.port, this.host, res -> {
            if (res.succeeded()) {
                future.complete((Object)Result.healthy());
            } else {
                future.complete((Object)Result.unhealthy((Throwable)res.cause()));
            }
            client.close();
        });
        return VertxCompletableFuture.from(this.vertx, future);
    }
}

