/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.standalone.jetty;

import io.gravitee.rest.api.standalone.jetty.JettyConfiguration;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.AsyncRequestLogWriter;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class JettyServerFactory
implements FactoryBean<Server> {
    private static final String KEYSTORE_TYPE_PKCS12 = "pkcs12";
    private static final String KEYSTORE_TYPE_JKS = "jks";
    @Autowired
    private JettyConfiguration jettyConfiguration;

    public Server getObject() throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool(this.jettyConfiguration.getPoolMaxThreads(), this.jettyConfiguration.getPoolMinThreads(), this.jettyConfiguration.getPoolIdleTimeout(), new ArrayBlockingQueue(this.jettyConfiguration.getPoolQueueSize()));
        threadPool.setName("gravitee-listener");
        Server server = new Server((ThreadPool)threadPool);
        server.setDumpAfterStart(false);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        if (this.jettyConfiguration.isJmxEnabled()) {
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            server.addBean((Object)mbContainer);
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setOutputBufferSize(32768);
        httpConfig.setRequestHeaderSize(8192);
        httpConfig.setResponseHeaderSize(8192);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(false);
        if (this.jettyConfiguration.isSecured()) {
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(this.jettyConfiguration.getHttpPort());
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            if (this.jettyConfiguration.getKeyStorePath() != null) {
                sslContextFactory.setKeyStorePath(this.jettyConfiguration.getKeyStorePath());
                sslContextFactory.setKeyStorePassword(this.jettyConfiguration.getKeyStorePassword());
                if (KEYSTORE_TYPE_PKCS12.equalsIgnoreCase(this.jettyConfiguration.getKeyStoreType())) {
                    sslContextFactory.setKeyStoreType(KEYSTORE_TYPE_PKCS12);
                }
            }
            if (this.jettyConfiguration.getTrustStorePath() != null) {
                sslContextFactory.setTrustStorePath(this.jettyConfiguration.getTrustStorePath());
                sslContextFactory.setTrustStorePassword(this.jettyConfiguration.getTrustStorePassword());
                if (KEYSTORE_TYPE_PKCS12.equalsIgnoreCase(this.jettyConfiguration.getTrustStoreType())) {
                    sslContextFactory.setTrustStoreType(KEYSTORE_TYPE_PKCS12);
                }
            }
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            https.setHost(this.jettyConfiguration.getHttpHost());
            https.setPort(this.jettyConfiguration.getHttpPort());
            server.addConnector((Connector)https);
        } else {
            ServerConnector http = new ServerConnector(server, this.jettyConfiguration.getAcceptors(), this.jettyConfiguration.getSelectors(), new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            http.setHost(this.jettyConfiguration.getHttpHost());
            http.setPort(this.jettyConfiguration.getHttpPort());
            http.setIdleTimeout((long)this.jettyConfiguration.getIdleTimeout());
            server.addConnector((Connector)http);
        }
        if (this.jettyConfiguration.isStatisticsEnabled()) {
            StatisticsHandler stats = new StatisticsHandler();
            stats.setHandler(server.getHandler());
            server.setHandler((Handler)stats);
        }
        if (this.jettyConfiguration.isAccessLogEnabled()) {
            CustomRequestLog requestLog = new CustomRequestLog((RequestLog.Writer)new AsyncRequestLogWriter(this.jettyConfiguration.getAccessLogPath()), "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"");
            server.setRequestLog((RequestLog)requestLog);
        }
        return server;
    }

    public Class<?> getObjectType() {
        return Server.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

