/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.v3.upgrader;

import io.gravitee.common.service.AbstractService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.IdentityProviderRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.model.IdentityProvider;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.RandomString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class V3UpgraderService
extends AbstractService {
    private final Logger logger = LoggerFactory.getLogger(V3UpgraderService.class);
    @Autowired
    private IdentityProviderRepository identityProviderRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private MembershipRepository membershipRepository;
    @Value(value="${services.v3-upgrader.enabled:true}")
    private boolean enabled;

    protected String name() {
        return "V3 Upgrader Service";
    }

    protected void doStart() throws Exception {
        if (this.enabled) {
            super.doStart();
            this.logger.info("v3 Upgrader service is enabled");
            this.convertIDPRoleMapping();
            this.moveIdpPermission();
        } else {
            this.logger.info("v3 Upgrader service has been disabled");
        }
    }

    public void convertIDPRoleMapping() {
        try {
            Set allIdps = this.identityProviderRepository.findAll();
            this.logger.debug("{} Idp found", (Object)allIdps.size());
            for (IdentityProvider idp : allIdps) {
                boolean idpHasBeenModified = false;
                Map roleMappings = idp.getRoleMappings();
                if (roleMappings != null) {
                    this.logger.debug("Idp '{}' has {} roleMappings", (Object)idp.getId(), (Object)roleMappings.size());
                    for (Map.Entry entry : roleMappings.entrySet()) {
                        String[] roles = (String[])entry.getValue();
                        if (roles != null) {
                            this.logger.debug("Idp '{}' - RoleMapping with condition '{}' has {} roles", new Object[]{idp.getId(), entry.getKey(), roles.length});
                            ArrayList<String> newRoles = new ArrayList<String>(roles.length);
                            boolean entryHasBeenModified = false;
                            for (String role : roles) {
                                String[] splittedRole = role.split(":");
                                if ("1".equals(splittedRole[0])) {
                                    Optional existingOrgaRoleWithSameName = this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.ORGANIZATION, splittedRole[1], "DEFAULT", RoleReferenceType.ORGANIZATION);
                                    if (existingOrgaRoleWithSameName.isPresent()) {
                                        newRoles.add("ORGANIZATION:" + splittedRole[1]);
                                    }
                                    newRoles.add("ENVIRONMENT:" + splittedRole[1]);
                                    entryHasBeenModified = true;
                                    continue;
                                }
                                if (!"2".equals(splittedRole[0])) continue;
                                newRoles.add("ENVIRONMENT:" + splittedRole[1]);
                                entryHasBeenModified = true;
                            }
                            if (!entryHasBeenModified) continue;
                            entry.setValue(newRoles.toArray(new String[newRoles.size()]));
                            idpHasBeenModified = true;
                            continue;
                        }
                        this.logger.debug("Idp '{}' - RoleMapping with condition '{}' has no roles", (Object)idp.getId(), entry.getKey());
                    }
                }
                if (idpHasBeenModified) {
                    this.identityProviderRepository.update(idp);
                    this.logger.info("Idp '{}' has been updated", (Object)idp.getId());
                    continue;
                }
                this.logger.info("Idp '{}' has not been updated", (Object)idp.getId());
            }
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to retrieve all identity providers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve identity providers", (Throwable)ex);
        }
    }

    public void moveIdpPermission() {
        try {
            Set allRole = this.roleRepository.findByScopeAndReferenceIdAndReferenceType(RoleScope.ENVIRONMENT, "DEFAULT", RoleReferenceType.ORGANIZATION);
            this.logger.info("{} environment roles found", (Object)allRole.size());
            for (Role envRole : allRole) {
                Role orgRole;
                int idpPerm = -1;
                int idpPermIndex = -1;
                int[] envPermissions = envRole.getPermissions();
                for (int index = 0; index < envPermissions.length; ++index) {
                    if (envPermissions[index] <= 3399 || envPermissions[index] >= 3500) continue;
                    idpPerm = envPermissions[index];
                    idpPermIndex = index;
                }
                if (idpPerm == -1 || idpPermIndex == -1) continue;
                this.logger.info("Permission: {} found on role {}", (Object)idpPerm, (Object)envRole.getName());
                Optional existingOrgRoleWithSameNameRoleCursor = this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.ORGANIZATION, envRole.getName(), envRole.getReferenceId(), envRole.getReferenceType());
                if (existingOrgRoleWithSameNameRoleCursor.isPresent()) {
                    this.logger.info("An org role exist with the same name");
                    orgRole = (Role)existingOrgRoleWithSameNameRoleCursor.get();
                    orgRole.setPermissions(ArrayUtils.add((int[])orgRole.getPermissions(), (int)(1300 + idpPerm % 100)));
                    this.logger.info("permissions updated");
                    this.roleRepository.update(orgRole);
                    this.logger.info("Update of org role done");
                } else {
                    this.logger.info("No org role exist with the same name");
                    orgRole = new Role();
                    orgRole.setId(RandomString.generate());
                    orgRole.setName(envRole.getName());
                    orgRole.setDefaultRole(envRole.isDefaultRole());
                    orgRole.setReferenceId(GraviteeContext.getDefaultOrganization());
                    orgRole.setReferenceType(RoleReferenceType.ORGANIZATION);
                    orgRole.setScope(RoleScope.ORGANIZATION);
                    orgRole.setCreatedAt(new Date());
                    orgRole.setDescription(envRole.getDescription());
                    orgRole.setSystem(envRole.isSystem());
                    orgRole.setPermissions(new int[]{1300 + idpPerm % 100});
                    this.roleRepository.create(orgRole);
                    this.logger.info("Creation of org role done");
                }
                envRole.setPermissions(ArrayUtils.remove((int[])envPermissions, (int)idpPermIndex));
                this.roleRepository.update(envRole);
                this.logger.info("Remove permission from env role done");
                Set envMembershipsWithRole = this.membershipRepository.findByReferenceAndRoleId(MembershipReferenceType.ENVIRONMENT, "DEFAULT", envRole.getId());
                for (Membership membership : envMembershipsWithRole) {
                    Set orgMembershipsWithRole = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId(membership.getMemberId(), membership.getMemberType(), MembershipReferenceType.ORGANIZATION, "DEFAULT", orgRole.getId());
                    if (!orgMembershipsWithRole.isEmpty()) continue;
                    Membership newOrganizationMembership = membership;
                    newOrganizationMembership.setId(RandomString.generate());
                    newOrganizationMembership.setReferenceId("DEFAULT");
                    newOrganizationMembership.setReferenceType(MembershipReferenceType.ORGANIZATION);
                    newOrganizationMembership.setRoleId(orgRole.getId());
                    this.membershipRepository.create(newOrganizationMembership);
                    this.logger.info("New membership {} on organization created for user {}", (Object)newOrganizationMembership.getId(), (Object)membership.getMemberId());
                }
            }
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to retrieve all identity providers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve identity providers", (Throwable)ex);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
    }
}

