/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.services.sync.ApiManager;
import io.gravitee.rest.api.services.sync.DictionaryManager;
import java.io.IOException;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncManager {
    private final Logger logger = LoggerFactory.getLogger(SyncManager.class);
    private static final int TIMEFRAME_BEFORE_DELAY = 600000;
    private static final int TIMEFRAME_AFTER_DELAY = 60000;
    @Autowired
    private DictionaryManager dictionaryManager;
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private ApiManager apiManager;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EventManager eventManager;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private UserService userService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ApiService apiService;
    private final AtomicLong counter = new AtomicLong(0L);
    private long lastRefreshAt = -1L;

    public void refresh() {
        this.logger.debug("Synchronization #{} started at {}", (Object)this.counter.incrementAndGet(), (Object)Instant.now());
        this.logger.debug("Refreshing state...");
        long nextLastRefreshAt = System.currentTimeMillis();
        try {
            this.synchronizeApis(nextLastRefreshAt);
        }
        catch (Exception ex) {
            this.logger.error("An error occurs while synchronizing APIs", (Throwable)ex);
        }
        try {
            this.synchronizeDictionaries(nextLastRefreshAt);
        }
        catch (Exception ex) {
            this.logger.error("An error occurs while synchronizing dictionaries", (Throwable)ex);
        }
        this.lastRefreshAt = nextLastRefreshAt;
        this.logger.debug("Synchronization #{} ended at {}", (Object)this.counter.get(), (Object)Instant.now());
    }

    private void synchronizeApis(long nextLastRefreshAt) {
        EventCriteria.Builder criteriaBuilder = new EventCriteria.Builder().types(new EventType[]{EventType.PUBLISH_API, EventType.UNPUBLISH_API, EventType.START_API, EventType.STOP_API}).from(this.lastRefreshAt - 600000L).to(nextLastRefreshAt + 60000L);
        Map<String, Event> apiEvents = this.eventRepository.searchLatest(criteriaBuilder.build(), Event.EventProperties.API_ID, null, null).stream().collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.API_ID.getValue()), event -> event));
        this.computeApiEvents(apiEvents);
    }

    private void synchronizeDictionaries(long nextLastRefreshAt) throws Exception {
        EventCriteria.Builder criteriaBuilder = new EventCriteria.Builder().types(new EventType[]{EventType.START_DICTIONARY, EventType.STOP_DICTIONARY}).from(this.lastRefreshAt - 600000L).to(nextLastRefreshAt + 60000L);
        Map<String, Event> dictionaryEvents = this.eventRepository.searchLatest(criteriaBuilder.build(), Event.EventProperties.DICTIONARY_ID, null, null).stream().collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.DICTIONARY_ID.getValue()), event -> event));
        this.computeDictionaryEvents(dictionaryEvents);
    }

    private void computeDictionaryEvents(Map<String, Event> dictionaryEvents) {
        dictionaryEvents.forEach((id, event) -> {
            switch (event.getType()) {
                case START_DICTIONARY: {
                    this.dictionaryManager.start((String)id);
                    break;
                }
                case STOP_DICTIONARY: {
                    this.dictionaryManager.stop((String)id);
                    break;
                }
            }
        });
    }

    private void computeApiEvents(Map<String, Event> apiEvents) {
        int parallelism = Runtime.getRuntime().availableProcessors() * 2;
        if (apiEvents.size() > parallelism) {
            ForkJoinPool customThreadPool = new ForkJoinPool(parallelism);
            customThreadPool.submit(() -> apiEvents.entrySet().parallelStream().forEach(e -> this.processApiEvent((String)e.getKey(), (Event)e.getValue())));
            customThreadPool.shutdown();
        } else {
            apiEvents.forEach(this::processApiEvent);
        }
    }

    private void processApiEvent(String apiId, Event apiEvent) {
        switch (apiEvent.getType()) {
            case UNPUBLISH_API: 
            case STOP_API: {
                this.apiManager.undeploy(apiId);
                break;
            }
            case START_API: 
            case PUBLISH_API: {
                try {
                    Api payloadApi = (Api)this.objectMapper.readValue(apiEvent.getPayload(), Api.class);
                    ApiEntity apiToDeploy = this.convert(payloadApi);
                    if (apiToDeploy == null) break;
                    ApiEntity deployedApi = this.apiManager.get(apiToDeploy.getId());
                    if (deployedApi == null) {
                        this.apiManager.deploy(apiToDeploy);
                        break;
                    }
                    if (!deployedApi.getDeployedAt().before(apiToDeploy.getDeployedAt())) break;
                    this.apiManager.update(apiToDeploy);
                }
                catch (Exception e) {
                    this.logger.error("Error while determining deployed APIs store into events payload", (Throwable)e);
                }
                break;
            }
        }
    }

    private ApiEntity convert(Api api) {
        ApiLifecycleState apiLifecycleState;
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        apiEntity.setName(api.getName());
        apiEntity.setDeployedAt(api.getDeployedAt());
        apiEntity.setCreatedAt(api.getCreatedAt());
        if (api.getDefinition() != null) {
            try {
                io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                apiEntity.setProxy(apiDefinition.getProxy());
                apiEntity.setPaths(apiDefinition.getPaths());
                apiEntity.setServices(apiDefinition.getServices());
                apiEntity.setResources(apiDefinition.getResources());
                apiEntity.setProperties(apiDefinition.getProperties());
                apiEntity.setTags(apiDefinition.getTags());
                if (apiDefinition.getPathMappings() != null) {
                    apiEntity.setPathMappings(new HashSet(apiDefinition.getPathMappings().keySet()));
                }
            }
            catch (IOException ioe) {
                this.logger.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        apiEntity.setUpdatedAt(api.getUpdatedAt());
        apiEntity.setVersion(api.getVersion());
        apiEntity.setDescription(api.getDescription());
        apiEntity.setPicture(api.getPicture());
        apiEntity.setBackground(api.getBackground());
        apiEntity.setCategories(api.getCategories());
        LifecycleState lifecycleState = api.getLifecycleState();
        if (lifecycleState != null) {
            apiEntity.setState(Lifecycle.State.valueOf((String)lifecycleState.name()));
        }
        if ((apiLifecycleState = api.getApiLifecycleState()) != null) {
            apiEntity.setLifecycleState(io.gravitee.rest.api.model.api.ApiLifecycleState.valueOf((String)apiLifecycleState.name()));
        }
        if (api.getVisibility() != null) {
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        EnvironmentEntity environmentEntity = this.environmentService.findById(api.getEnvironmentId());
        GraviteeContext.setCurrentOrganization((String)environmentEntity.getOrganizationId());
        apiEntity.setPrimaryOwner(this.apiService.getPrimaryOwner(api.getId()));
        return apiEntity;
    }
}

