/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.exceptions.PrimaryOwnerNotFoundException;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import io.gravitee.rest.api.services.sync.ApiManager;
import io.gravitee.rest.api.services.sync.DictionaryManager;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class SyncManager {
    private static final int TIMEFRAME_BEFORE_DELAY = 600000;
    private static final int TIMEFRAME_AFTER_DELAY = 60000;
    private final Logger logger = LoggerFactory.getLogger(SyncManager.class);
    private final AtomicLong counter = new AtomicLong(0L);
    @Autowired
    private DictionaryManager dictionaryManager;
    @Lazy
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private ApiManager apiManager;
    @Autowired
    private ApiConverter apiConverter;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private PrimaryOwnerService primaryOwnerService;
    @Autowired
    private ApiMapper apiMapper;
    private long lastRefreshAt = -1L;

    public void refresh() {
        this.logger.debug("Synchronization #{} started at {}", (Object)this.counter.incrementAndGet(), (Object)Instant.now());
        this.logger.debug("Refreshing state...");
        long nextLastRefreshAt = System.currentTimeMillis();
        try {
            this.synchronizeApis(nextLastRefreshAt);
        }
        catch (Exception ex) {
            this.logger.error("An error occurs while synchronizing APIs", (Throwable)ex);
        }
        try {
            this.synchronizeDictionaries(nextLastRefreshAt);
        }
        catch (Exception ex) {
            this.logger.error("An error occurs while synchronizing dictionaries", (Throwable)ex);
        }
        this.lastRefreshAt = nextLastRefreshAt;
        this.logger.debug("Synchronization #{} ended at {}", (Object)this.counter.get(), (Object)Instant.now());
    }

    private void synchronizeApis(long nextLastRefreshAt) {
        EventCriteria.Builder criteriaBuilder = new EventCriteria.Builder().types(new EventType[]{EventType.PUBLISH_API, EventType.UNPUBLISH_API, EventType.START_API, EventType.STOP_API}).from(this.lastRefreshAt - 600000L).to(nextLastRefreshAt + 60000L);
        Map<String, Event> apiEvents = this.eventRepository.searchLatest(criteriaBuilder.build(), Event.EventProperties.API_ID, null, null).stream().collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.API_ID.getValue()), event -> event));
        this.computeApiEvents(apiEvents);
    }

    private void synchronizeDictionaries(long nextLastRefreshAt) throws Exception {
        EventCriteria.Builder criteriaBuilder = new EventCriteria.Builder().types(new EventType[]{EventType.START_DICTIONARY, EventType.STOP_DICTIONARY}).from(this.lastRefreshAt - 600000L).to(nextLastRefreshAt + 60000L);
        Map<String, Event> dictionaryEvents = this.eventRepository.searchLatest(criteriaBuilder.build(), Event.EventProperties.DICTIONARY_ID, null, null).stream().collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.DICTIONARY_ID.getValue()), event -> event));
        this.computeDictionaryEvents(dictionaryEvents);
    }

    private void computeDictionaryEvents(Map<String, Event> dictionaryEvents) {
        dictionaryEvents.forEach((id, event) -> {
            switch (event.getType()) {
                case START_DICTIONARY: {
                    this.dictionaryManager.start((String)id);
                    break;
                }
                case STOP_DICTIONARY: {
                    this.dictionaryManager.stop((String)id);
                    break;
                }
            }
        });
    }

    private void computeApiEvents(Map<String, Event> apiEvents) {
        int parallelism = Runtime.getRuntime().availableProcessors() * 2;
        if (apiEvents.size() > parallelism) {
            ForkJoinPool.ForkJoinWorkerThreadFactory factory = pool -> {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName("gio.sync-" + worker.getPoolIndex());
                return worker;
            };
            ForkJoinPool customThreadPool = new ForkJoinPool(parallelism, factory, null, false);
            customThreadPool.submit(() -> apiEvents.entrySet().parallelStream().forEach(e -> this.processApiEvent((String)e.getKey(), (Event)e.getValue())));
            customThreadPool.shutdown();
        } else {
            apiEvents.forEach(this::processApiEvent);
        }
    }

    protected void processApiEvent(String apiId, Event apiEvent) {
        switch (apiEvent.getType()) {
            case UNPUBLISH_API: 
            case STOP_API: {
                this.apiManager.undeploy(apiId);
                break;
            }
            case START_API: 
            case PUBLISH_API: {
                try {
                    Api payloadApi = (Api)this.objectMapper.readValue(apiEvent.getPayload(), Api.class);
                    Object indexableApiToDeploy = payloadApi.getDefinitionVersion() == null || payloadApi.getDefinitionVersion() != DefinitionVersion.V4 ? this.convert(payloadApi) : this.convertV4(payloadApi);
                    if (indexableApiToDeploy == null) break;
                    GenericApiEntity deployedApi = this.apiManager.get(indexableApiToDeploy.getId());
                    if (deployedApi == null) {
                        this.apiManager.deploy((GenericApiEntity)indexableApiToDeploy);
                        break;
                    }
                    if (!deployedApi.getDeployedAt().before(indexableApiToDeploy.getDeployedAt())) break;
                    this.apiManager.update((GenericApiEntity)indexableApiToDeploy);
                }
                catch (Exception e) {
                    this.logger.error("Unable to handle event [" + apiEvent.getType() + "]  for API [" + apiId + "]", (Throwable)e);
                }
                break;
            }
        }
    }

    private ApiEntity convert(Api api) {
        if (api.getEnvironmentId() == null) {
            api.setEnvironmentId(GraviteeContext.getDefaultEnvironment());
        }
        EnvironmentEntity environmentEntity = this.environmentService.findById(api.getEnvironmentId());
        GraviteeContext.setCurrentOrganization((String)environmentEntity.getOrganizationId());
        PrimaryOwnerEntity primaryOwnerEntity = null;
        try {
            primaryOwnerEntity = this.primaryOwnerService.getPrimaryOwner(GraviteeContext.getExecutionContext(), api.getId());
        }
        catch (PrimaryOwnerNotFoundException e) {
            this.logger.error(e.getMessage());
        }
        return this.apiConverter.toApiEntity(api, primaryOwnerEntity);
    }

    private io.gravitee.rest.api.model.v4.api.ApiEntity convertV4(Api api) {
        PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(GraviteeContext.getExecutionContext(), api.getId());
        return this.apiMapper.toEntity(api, primaryOwner);
    }
}

