/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.subscriptionpreexpirationnotif;

import com.google.common.annotations.VisibleForTesting;
import io.gravitee.common.service.AbstractService;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.key.ApiKeyQuery;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.EmailNotification;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class ScheduledSubscriptionPreExpirationNotificationService
extends AbstractService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ScheduledSubscriptionPreExpirationNotificationService.class);
    private final String cronTrigger = "0 0 */1 * * *";
    private final int cronPeriodInMs = 3600000;
    private final AtomicLong counter = new AtomicLong(0L);
    @Autowired
    private ApiSearchService apiSearchService;
    @Autowired
    private ApiKeyService apiKeyService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private PlanSearchService planSearchService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private UserService userService;
    @Autowired
    @Qualifier(value="subscriptionPreExpirationTaskScheduler")
    private TaskScheduler scheduler;
    @Value(value="#{'${services.subscription.pre-expiration-notification-schedule:90,45,30}'.split(',')}")
    private List<Integer> configPreExpirationNotificationSchedule;
    @Value(value="${services.subscription.enabled:true}")
    private boolean enabled;
    private List<Integer> notificationDays;

    protected String name() {
        return "Subscription Pre Expiration Notification service";
    }

    protected void doStart() {
        if (this.enabled) {
            this.notificationDays = this.getCleanedNotificationDays(this.configPreExpirationNotificationSchedule);
            this.logger.info("Subscription Pre Expiration Notification service has been initialized with cron [{}]", (Object)"0 0 */1 * * *");
            this.scheduler.schedule((Runnable)this, (Trigger)new CronTrigger("0 0 */1 * * *"));
        } else {
            this.logger.warn("Subscription Pre Expiration Notification service has been disabled");
        }
    }

    @Override
    public void run() {
        this.logger.debug("Subscription Pre Expiration Notification #{} started at {}", (Object)this.counter.incrementAndGet(), (Object)Instant.now().toString());
        Instant now = Instant.now();
        this.notificationDays.forEach(daysToExpiration -> {
            Set<String> notifiedSubscriptionIds = this.notifySubscriptionsExpirations(now, (Integer)daysToExpiration);
            this.notifyApiKeysExpirations(now, (Integer)daysToExpiration, notifiedSubscriptionIds);
        });
        this.logger.debug("Subscription Pre Expiration Notification #{} ended at {}", (Object)this.counter.get(), (Object)Instant.now().toString());
    }

    private void notifyApiKeysExpirations(Instant now, Integer daysToExpiration, Set<String> notifiedSubscriptionIds) {
        Collection<ApiKeyEntity> apiKeyExpirationsToNotify = this.findApiKeyExpirationsToNotify(now, daysToExpiration);
        apiKeyExpirationsToNotify.stream().filter(apiKey -> apiKey.getDaysToExpirationOnLastNotification() == null || apiKey.getDaysToExpirationOnLastNotification() > daysToExpiration).forEach(apiKey -> this.notifyApiKeyExpiration(daysToExpiration, (ApiKeyEntity)apiKey, notifiedSubscriptionIds));
    }

    private void notifyApiKeyExpiration(Integer daysToExpiration, ApiKeyEntity apiKey, Set<String> notifiedSubscriptionIds) {
        ApplicationEntity application = apiKey.getApplication();
        apiKey.getSubscriptions().stream().filter(subscription -> !notifiedSubscriptionIds.contains(subscription.getId())).forEach(subscription -> {
            GenericApiEntity api = this.apiSearchService.findGenericById(GraviteeContext.getExecutionContext(), subscription.getApi());
            GenericPlanEntity plan = this.planSearchService.findById(GraviteeContext.getExecutionContext(), subscription.getPlan());
            this.findEmailsToNotify((SubscriptionEntity)subscription, application).forEach(email -> this.sendEmail((String)email, daysToExpiration, api, plan, application, apiKey));
        });
        this.apiKeyService.updateDaysToExpirationOnLastNotification(GraviteeContext.getExecutionContext(), apiKey, daysToExpiration);
    }

    private Set<String> notifySubscriptionsExpirations(Instant now, Integer daysToExpiration) {
        Collection<SubscriptionEntity> subscriptionExpirationsToNotify = this.findSubscriptionExpirationsToNotify(now, daysToExpiration);
        this.findSubscriptionExpirationsToNotify(now, daysToExpiration).stream().filter(subscription -> subscription.getDaysToExpirationOnLastNotification() == null || subscription.getDaysToExpirationOnLastNotification() > daysToExpiration).forEach(subscription -> this.notifySubscriptionExpiration(daysToExpiration, (SubscriptionEntity)subscription));
        return subscriptionExpirationsToNotify.stream().map(SubscriptionEntity::getId).collect(Collectors.toSet());
    }

    private void notifySubscriptionExpiration(Integer daysToExpiration, SubscriptionEntity subscription) {
        ApiEntity api = this.apiSearchService.findById(GraviteeContext.getExecutionContext(), subscription.getApi());
        GenericPlanEntity plan = this.planSearchService.findById(GraviteeContext.getExecutionContext(), subscription.getPlan());
        ApplicationEntity application = this.applicationService.findById(GraviteeContext.getExecutionContext(), subscription.getApplication());
        this.findEmailsToNotify(subscription, application).forEach(arg_0 -> this.lambda$notifySubscriptionExpiration$8(daysToExpiration, (GenericApiEntity)api, plan, application, arg_0));
        this.subscriptionService.updateDaysToExpirationOnLastNotification(subscription.getId(), daysToExpiration);
    }

    @VisibleForTesting
    List<Integer> getCleanedNotificationDays(List<Integer> inputDays) {
        int min = 1;
        int max = 366;
        Predicate<Integer> isDayValid = day -> min <= day && day <= max;
        List invalidValues = inputDays.stream().filter(day -> !isDayValid.test((Integer)day)).collect(Collectors.toList());
        if (!invalidValues.isEmpty()) {
            this.logger.warn("The configuration key `services.subscription.pre-expiration-notification-schedule` contains some invalid values: {}. Values should be between {} and {} (days).", new Object[]{invalidValues.stream().map(Object::toString).collect(Collectors.joining(", ")), min, max});
        }
        return inputDays.stream().filter(isDayValid).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    @VisibleForTesting
    Collection<SubscriptionEntity> findSubscriptionExpirationsToNotify(Instant now, Integer daysToExpiration) {
        long expirationStartingTime = now.plus(Duration.ofDays(daysToExpiration.intValue())).getEpochSecond() * 1000L;
        SubscriptionQuery query = new SubscriptionQuery();
        query.setStatuses(Arrays.asList(SubscriptionStatus.ACCEPTED, SubscriptionStatus.PAUSED));
        query.setEndingAtAfter(expirationStartingTime);
        query.setEndingAtBefore(expirationStartingTime + 3600000L);
        return this.subscriptionService.search(GraviteeContext.getExecutionContext(), query);
    }

    @VisibleForTesting
    Collection<ApiKeyEntity> findApiKeyExpirationsToNotify(Instant now, Integer daysToExpiration) {
        long expirationStartingTime = now.plus(Duration.ofDays(daysToExpiration.intValue())).getEpochSecond() * 1000L;
        ApiKeyQuery query = new ApiKeyQuery();
        query.setIncludeRevoked(false);
        query.setIncludeFederated(true);
        query.setExpireAfter(expirationStartingTime);
        query.setExpireBefore(expirationStartingTime + 3600000L);
        return this.apiKeyService.search(GraviteeContext.getExecutionContext(), query);
    }

    @VisibleForTesting
    Set<String> findEmailsToNotify(SubscriptionEntity subscription, ApplicationEntity application) {
        HashSet<String> emails = new HashSet<String>();
        emails.add(this.userService.findById(GraviteeContext.getExecutionContext(), subscription.getSubscribedBy()).getEmail());
        emails.add(application.getPrimaryOwner().getEmail());
        return emails.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @VisibleForTesting
    void sendEmail(String subscriberEmail, int day, GenericApiEntity api, GenericPlanEntity plan, ApplicationEntity application, ApiKeyEntity apiKey) {
        EmailNotification emailNotification = new EmailNotificationBuilder().to(new String[]{subscriberEmail}).template(EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_SUBSCRIPTION_PRE_EXPIRATION).param("expirationDelay", (Object)day).param("plan", (Object)plan).param("api", (Object)api).param("application", (Object)application).param("apiKey", (Object)apiKey).build();
        this.emailService.sendAsyncEmailNotification(GraviteeContext.getExecutionContext(), emailNotification);
    }

    private /* synthetic */ void lambda$notifySubscriptionExpiration$8(Integer daysToExpiration, GenericApiEntity api, GenericPlanEntity plan, ApplicationEntity application, String email) {
        this.sendEmail(email, daysToExpiration, api, plan, application, null);
    }
}

