/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.events;

import io.gravitee.apim.core.event.use_case.CleanupEventsUseCase;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.common.service.AbstractService;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.OrganizationService;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class ScheduledEventsCleaningService
extends AbstractService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ScheduledEventsCleaningService.class);
    private final CleanupEventsUseCase cleanupEventsUseCase;
    private final OrganizationService organizationService;
    private final EnvironmentService environmentService;
    private final TaskScheduler scheduler;
    private final String cronTrigger;
    private final int eventsKeep;
    private final boolean enabled;
    private final Duration timeToLive;

    @Autowired
    public ScheduledEventsCleaningService(CleanupEventsUseCase cleanupEventsUseCase, OrganizationService organizationService, EnvironmentService environmentService, @Qualifier(value="eventsCleaningTaskScheduler") TaskScheduler scheduler, @Value(value="${services.events.cron:@daily}") String cronTrigger, @Value(value="${services.events.keep:5}") int eventsKeep, @Value(value="${services.events.enabled:false}") boolean enabled, @Value(value="${services.events.timeToLive:30}") long timeToLive) {
        this.cleanupEventsUseCase = cleanupEventsUseCase;
        this.organizationService = organizationService;
        this.environmentService = environmentService;
        this.scheduler = scheduler;
        this.cronTrigger = cronTrigger;
        this.eventsKeep = eventsKeep;
        this.enabled = enabled;
        this.timeToLive = Duration.ofMinutes(timeToLive);
    }

    protected void doStart() throws Exception {
        if (this.enabled) {
            super.doStart();
            this.logger.info("Event cleaner service has been initialized with cron [{}]", (Object)this.cronTrigger);
            this.scheduler.schedule((Runnable)this, (Trigger)new CronTrigger(this.cronTrigger));
        } else {
            this.logger.warn("Event cleaner Refresher service has been disabled");
        }
    }

    @Override
    public void run() {
        List environments = CollectionUtils.stream((Iterable)this.organizationService.findAll()).flatMap(o -> CollectionUtils.stream((Iterable)this.environmentService.findByOrganization(o.getId()))).toList();
        for (EnvironmentEntity environment : environments) {
            this.logger.info("Start cleanup environment: {} ({}) from organisation {}", new Object[]{environment.getName(), environment.getId(), environment.getOrganizationId()});
            this.cleanupEventsUseCase.execute(new CleanupEventsUseCase.Input(environment.getId(), this.eventsKeep, this.timeToLive));
        }
    }
}

