/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties;

import io.gravitee.common.cron.CronTrigger;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Property;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.UserRoleEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.SecurityContextHelper;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.services.dynamicproperties.model.DynamicProperty;
import io.gravitee.rest.api.services.dynamicproperties.provider.Provider;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPropertyScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicPropertyScheduler.class);
    private final ClusterManager clusterManager;
    private final ApiService apiService;
    private final ApiConverter apiConverter;
    private final String schedule;
    private final ApiEntity api;
    private final ExecutionContext executionContext;
    private Disposable disposable;

    public DynamicPropertyScheduler(ClusterManager clusterManager, ApiService apiService, ApiConverter apiConverter, String schedule, ApiEntity api, ExecutionContext executionContext) {
        this.clusterManager = clusterManager;
        this.apiService = apiService;
        this.apiConverter = apiConverter;
        this.schedule = schedule;
        this.api = api;
        this.executionContext = executionContext;
    }

    public void schedule(Provider provider) {
        CronTrigger cronTrigger = new CronTrigger(this.schedule);
        log.debug("[{}] Running dynamic properties scheduler", (Object)this.api.getId());
        this.disposable = Observable.defer(() -> Observable.timer((long)cronTrigger.nextExecutionIn(), (TimeUnit)TimeUnit.MILLISECONDS)).observeOn(Schedulers.computation()).filter(aLong -> this.clusterManager.self().primary()).switchMapCompletable(aLong -> provider.get().flatMapCompletable(dynamicProperties -> Completable.fromRunnable(() -> {
            log.debug("[{}] Got {} dynamic properties to update", (Object)this.api.getId(), (Object)dynamicProperties.size());
            this.authenticateAsAdmin();
            this.update((List<DynamicProperty>)dynamicProperties);
        })).doOnComplete(() -> log.debug("[{}] Dynamic properties updated", (Object)this.api.getId()))).onErrorResumeNext(throwable -> {
            log.error("[{}] Unexpected error while getting dynamic properties from provider: {}", new Object[]{this.api.getId(), provider.name(), throwable});
            return Completable.complete();
        }).repeat().subscribe(() -> {}, throwable -> log.error("Unable to run Dynamic Properties for Api: {}", (Object)this.api.getId()));
    }

    public void cancel() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
    }

    private void authenticateAsAdmin() {
        UserRoleEntity adminRole = new UserRoleEntity();
        adminRole.setScope(RoleScope.ENVIRONMENT);
        adminRole.setName(SystemRole.ADMIN.name());
        SecurityContextHelper.authenticateAsSystem((String)"DynamicPropertyUpdater", Set.of(adminRole));
    }

    private void update(List<DynamicProperty> dynamicProperties) {
        ApiEntity latestApi = this.apiService.findById(this.executionContext, this.api.getId());
        List properties = latestApi.getProperties() != null ? latestApi.getProperties().getProperties() : Collections.emptyList();
        List<Property> userDefinedProperties = properties.stream().filter(property -> !property.isDynamic()).toList();
        Map<String, Property> propertyMap = properties.stream().collect(Collectors.toMap(Property::getKey, property -> property));
        ArrayList<Property> updatedProperties = new ArrayList<Property>();
        boolean needToBeSaved = false;
        for (DynamicProperty dynamicProperty : dynamicProperties) {
            Property property2 = propertyMap.get(dynamicProperty.getKey());
            if (property2 == null || property2.isDynamic()) {
                updatedProperties.add(dynamicProperty);
            }
            if (property2 != null && (!property2.isDynamic() || property2.getValue().equals(dynamicProperty.getValue()))) continue;
            needToBeSaved = true;
        }
        if (needToBeSaved) {
            updatedProperties.addAll(userDefinedProperties);
            List sortedUpdatedProperties = updatedProperties.stream().sorted(Comparator.comparing(Property::getKey)).collect(Collectors.toList());
            Properties apiProperties = new Properties();
            try {
                apiProperties.setProperties(sortedUpdatedProperties);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            latestApi.setProperties(apiProperties);
            boolean isSync = this.apiService.isSynchronized(this.executionContext, this.api.getId());
            try {
                log.debug("[{}] Updating API", (Object)latestApi.getId());
                this.apiService.update(this.executionContext, latestApi.getId(), this.apiConverter.toUpdateApiEntity(latestApi), false, false);
                log.debug("[{}] API has been updated", (Object)latestApi.getId());
            }
            catch (TechnicalManagementException e) {
                log.error("An error occurred while updating the API with new values of dynamic properties, deployment will be skipped.", (Throwable)e);
                throw e;
            }
            if (!(!isSync || updatedProperties.containsAll(properties) && properties.containsAll(updatedProperties))) {
                log.debug("[{}] Property change detected, API is about to be deployed", (Object)this.api.getId());
                ApiDeploymentEntity deployEntity = new ApiDeploymentEntity();
                deployEntity.setDeploymentLabel("Dynamic properties sync");
                this.apiService.deploy(this.executionContext, latestApi.getId(), "dynamic-property-updater", EventType.PUBLISH_API, deployEntity);
                log.debug("[{}] API as been deployed", (Object)this.api.getId());
            }
        }
    }

    @Generated
    public static DynamicPropertySchedulerBuilder builder() {
        return new DynamicPropertySchedulerBuilder();
    }

    @Generated
    public static class DynamicPropertySchedulerBuilder {
        @Generated
        private ClusterManager clusterManager;
        @Generated
        private ApiService apiService;
        @Generated
        private ApiConverter apiConverter;
        @Generated
        private String schedule;
        @Generated
        private ApiEntity api;
        @Generated
        private ExecutionContext executionContext;

        @Generated
        DynamicPropertySchedulerBuilder() {
        }

        @Generated
        public DynamicPropertySchedulerBuilder clusterManager(ClusterManager clusterManager) {
            this.clusterManager = clusterManager;
            return this;
        }

        @Generated
        public DynamicPropertySchedulerBuilder apiService(ApiService apiService) {
            this.apiService = apiService;
            return this;
        }

        @Generated
        public DynamicPropertySchedulerBuilder apiConverter(ApiConverter apiConverter) {
            this.apiConverter = apiConverter;
            return this;
        }

        @Generated
        public DynamicPropertySchedulerBuilder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        @Generated
        public DynamicPropertySchedulerBuilder api(ApiEntity api) {
            this.api = api;
            return this;
        }

        @Generated
        public DynamicPropertySchedulerBuilder executionContext(ExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        @Generated
        public DynamicPropertyScheduler build() {
            return new DynamicPropertyScheduler(this.clusterManager, this.apiService, this.apiConverter, this.schedule, this.api, this.executionContext);
        }

        @Generated
        public String toString() {
            return "DynamicPropertyScheduler.DynamicPropertySchedulerBuilder(clusterManager=" + this.clusterManager + ", apiService=" + this.apiService + ", apiConverter=" + this.apiConverter + ", schedule=" + this.schedule + ", api=" + this.api + ", executionContext=" + this.executionContext + ")";
        }
    }
}

