/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dictionary.provider.http;

import io.gravitee.node.api.Node;
import io.gravitee.node.api.utils.NodeUtils;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.services.dictionary.model.DynamicProperty;
import io.gravitee.rest.api.services.dictionary.provider.Provider;
import io.gravitee.rest.api.services.dictionary.provider.http.configuration.HttpProviderConfiguration;
import io.gravitee.rest.api.services.dictionary.provider.http.mapper.JoltMapper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.springframework.util.StringUtils;

public class HttpProvider
implements Provider {
    private static final String HTTPS_SCHEME = "https";
    private final HttpProviderConfiguration configuration;
    private JoltMapper mapper;
    private HttpClientService httpClientService;
    private Node node;

    public HttpProvider(HttpProviderConfiguration configuration) {
        Objects.requireNonNull(configuration, "Configuration must not be null");
        this.configuration = configuration;
        this.mapper = new JoltMapper(configuration.getSpecification());
    }

    @Override
    public CompletableFuture<Collection<DynamicProperty>> get() {
        final Promise promise = Promise.promise();
        try {
            URL requestUrl = new URL(this.configuration.getUrl());
            final HttpClient httpClient = this.httpClientService.createHttpClient(requestUrl.getProtocol(), Boolean.valueOf(this.configuration.isUseSystemProxy()));
            int port = requestUrl.getPort() != -1 ? requestUrl.getPort() : (HTTPS_SCHEME.equals(requestUrl.getProtocol()) ? 443 : 80);
            String relativeUri = requestUrl.getQuery() == null ? requestUrl.getPath() : requestUrl.getPath() + "?" + requestUrl.getQuery();
            RequestOptions options = new RequestOptions().setMethod(this.configuration.getMethod() != null ? this.configuration.getMethod() : HttpMethod.GET).setHost(requestUrl.getHost()).setPort(Integer.valueOf(port)).setURI(relativeUri);
            options.putHeader("User-Agent", NodeUtils.userAgent((Node)this.node));
            options.putHeader("X-Gravitee-Request-Id", UuidString.generateRandom());
            if (this.configuration.getHeaders() != null) {
                this.configuration.getHeaders().forEach(httpHeader -> options.putHeader(httpHeader.getName(), httpHeader.getValue()));
            }
            httpClient.request(options).onFailure((Handler)new Handler<Throwable>(){

                public void handle(Throwable event) {
                    promise.fail(event);
                    httpClient.close();
                }
            }).onSuccess((Handler)new Handler<HttpClientRequest>(){

                public void handle(HttpClientRequest request) {
                    request.response((Handler)new Handler<AsyncResult<HttpClientResponse>>(){

                        public void handle(AsyncResult<HttpClientResponse> asyncResponse) {
                            if (asyncResponse.failed()) {
                                promise.fail(asyncResponse.cause());
                                httpClient.close();
                            } else {
                                HttpClientResponse response = (HttpClientResponse)asyncResponse.result();
                                if (response.statusCode() == 200) {
                                    response.bodyHandler(buffer -> {
                                        promise.complete(buffer);
                                        httpClient.close();
                                    });
                                } else {
                                    promise.complete(null);
                                    httpClient.close();
                                }
                            }
                        }
                    }).exceptionHandler((Handler)new Handler<Throwable>(){

                        public void handle(Throwable throwable) {
                            promise.fail(throwable);
                            httpClient.close();
                        }
                    });
                    if (!StringUtils.isEmpty((Object)HttpProvider.this.configuration.getBody())) {
                        request.end(HttpProvider.this.configuration.getBody());
                    } else {
                        request.end();
                    }
                }
            });
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future().map((Function)new Function<Buffer, Collection<DynamicProperty>>(){

            @Override
            public Collection<DynamicProperty> apply(Buffer buffer) {
                if (buffer == null) {
                    return null;
                }
                return HttpProvider.this.mapper.map(buffer.toString());
            }
        }).toCompletionStage().toCompletableFuture();
    }

    @Override
    public String name() {
        return "custom";
    }

    public void setMapper(JoltMapper mapper) {
        this.mapper = mapper;
    }

    public void setHttpClientService(HttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }

    public void setNode(Node node) {
        this.node = node;
    }
}

