/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dictionary.provider.http.mapper;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.JsonUtils;
import com.bazaarvoice.jolt.chainr.ChainrBuilder;
import io.gravitee.rest.api.services.dictionary.model.DynamicProperty;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoltMapper {
    private final Logger logger = LoggerFactory.getLogger(JoltMapper.class);
    private final Chainr chainr;

    public JoltMapper(String specification) {
        Objects.requireNonNull(specification, "Specification must not be null");
        this.chainr = new ChainrBuilder((Object)JsonUtils.jsonToList((String)specification)).build();
    }

    public JoltMapper(InputStream specification) {
        Objects.requireNonNull(specification, "Specification must not be null");
        this.chainr = new ChainrBuilder((Object)JsonUtils.jsonToList((InputStream)specification)).build();
    }

    public Collection<DynamicProperty> map(String source) {
        String jsonProperties = source;
        ArrayList transformed = jsonProperties != null && jsonProperties.charAt(0) == '[' ? (ArrayList)this.chainr.transform((Object)JsonUtils.jsonToList((String)source)) : (ArrayList)this.chainr.transform((Object)JsonUtils.jsonToMap((String)source));
        jsonProperties = JsonUtils.toJsonString((Object)transformed);
        List items = JsonUtils.jsonToList((String)jsonProperties);
        List collect = items.stream().map((? super T item) -> {
            Map mapItem = (Map)item;
            Object key = mapItem.get("key");
            if (key instanceof Number) {
                return new DynamicProperty(key.toString(), (String)mapItem.get("value"));
            }
            return new DynamicProperty((String)key, (String)mapItem.get("value"));
        }).collect(Collectors.toList());
        return collect;
    }
}

