/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.audit;

import io.gravitee.apim.core.audit.use_case.RemoveOldAuditDataUseCase;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.common.service.AbstractService;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.OrganizationService;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class ScheduledAuditCleanerService
extends AbstractService
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduledAuditCleanerService.class);
    private final TaskScheduler scheduler;
    private final String cronTrigger;
    private final boolean enabled;
    private final RemoveOldAuditDataUseCase removeOldAuditDataUseCase;
    private final OrganizationService organizationService;
    private final EnvironmentService environmentService;
    private final Duration maxAge;

    public ScheduledAuditCleanerService(@Qualifier(value="auditTaskScheduler") TaskScheduler scheduler, @Value(value="${services.audit.cron:0 1 * * * *}") String cronTrigger, @Value(value="${services.audit.enabled:true}") boolean enabled, @Value(value="${services.audit.retention.days:365}") int maxAgeInDays, RemoveOldAuditDataUseCase removeOldAuditDataUseCase, OrganizationService organizationService, EnvironmentService environmentService) {
        this.scheduler = scheduler;
        this.cronTrigger = cronTrigger;
        this.enabled = enabled;
        this.removeOldAuditDataUseCase = removeOldAuditDataUseCase;
        this.organizationService = organizationService;
        this.environmentService = environmentService;
        this.maxAge = Duration.ofDays(maxAgeInDays);
    }

    protected String name() {
        return "Subscriptions Refresher Service";
    }

    protected void doStart() throws Exception {
        if (this.enabled) {
            super.doStart();
            log.info("Audit cleaner service has been initialized with cron [{}]", (Object)this.cronTrigger);
            this.scheduler.schedule((Runnable)this, (Trigger)new CronTrigger(this.cronTrigger));
        } else {
            log.warn("Audit cleaner service has been disabled");
        }
    }

    @Override
    public void run() {
        List environments = CollectionUtils.stream((Iterable)this.organizationService.findAll()).flatMap(o -> CollectionUtils.stream((Iterable)this.environmentService.findByOrganization(o.getId()))).toList();
        for (EnvironmentEntity environment : environments) {
            log.info("Start cleanup environment: {} ({}) from organisation {}", new Object[]{environment.getName(), environment.getId(), environment.getOrganizationId()});
            this.removeOldAuditDataUseCase.execute(new RemoveOldAuditDataUseCase.Input(environment.getId(), this.maxAge));
        }
    }
}

