/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.security.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.idp.api.IdentityProvider;
import io.gravitee.rest.api.idp.api.authentication.AuthenticationProvider;
import io.gravitee.rest.api.idp.core.plugin.IdentityProviderManager;
import io.gravitee.rest.api.management.security.config.GraviteeUrlBasedCorsConfigurationSource;
import io.gravitee.rest.api.security.authentication.AuthenticationProviderManager;
import io.gravitee.rest.api.security.authentication.GraviteeAuthenticationDetails;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import io.gravitee.rest.api.security.csrf.CookieCsrfSignedTokenRepository;
import io.gravitee.rest.api.security.csrf.CsrfRequestMatcher;
import io.gravitee.rest.api.security.filter.CsrfIncludeFilter;
import io.gravitee.rest.api.security.filter.RecaptchaFilter;
import io.gravitee.rest.api.security.filter.TokenAuthenticationFilter;
import io.gravitee.rest.api.security.listener.AuthenticationFailureListener;
import io.gravitee.rest.api.security.listener.AuthenticationSuccessListener;
import io.gravitee.rest.api.security.utils.AuthoritiesProvider;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.ReCaptchaService;
import io.gravitee.rest.api.service.TokenService;
import io.gravitee.rest.api.service.UserService;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfigurationSource;

@Configuration
@Profile(value={"basic"})
@EnableWebSecurity
public class BasicSecurityConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicSecurityConfigurerAdapter.class);
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private IdentityProviderManager identityProviderManager;
    @Autowired
    private AuthenticationProviderManager authenticationProviderManager;
    @Autowired
    private CookieGenerator cookieGenerator;
    @Autowired
    private ReCaptchaService reCaptchaService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private AuthoritiesProvider authoritiesProvider;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private EventManager eventManager;

    @Bean
    public AuthenticationSuccessListener authenticationSuccessListener() {
        return new AuthenticationSuccessListener();
    }

    @Bean
    public AuthenticationFailureListener authenticationFailureListener() {
        return new AuthenticationFailureListener();
    }

    @Bean
    public CookieCsrfSignedTokenRepository cookieCsrfSignedTokenRepository() {
        return new CookieCsrfSignedTokenRepository();
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        return new GraviteeUrlBasedCorsConfigurationSource(this.parameterService, this.eventManager);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        String jwtSecret = this.environment.getProperty("jwt.secret");
        if (jwtSecret == null || jwtSecret.isEmpty()) {
            throw new IllegalStateException("JWT secret is mandatory");
        }
        if ("myJWT4Gr4v1t33_S3cr3t".equals(jwtSecret)) {
            LOGGER.warn("");
            LOGGER.warn("##############################################################");
            LOGGER.warn("#                      SECURITY WARNING                      #");
            LOGGER.warn("##############################################################");
            LOGGER.warn("");
            LOGGER.warn("You still use the default jwt secret.");
            LOGGER.warn("This known secret can be used to impersonate anyone.");
            LOGGER.warn("Please change this value, or ask your administrator to do it !");
            LOGGER.warn("");
            LOGGER.warn("##############################################################");
            LOGGER.warn("");
        }
        this.authenticationManager(http);
        this.authentication(http);
        this.session(http);
        this.authorizations(http);
        this.hsts(http);
        this.csrf(http);
        this.cors(http);
        http.addFilterBefore((Filter)new TokenAuthenticationFilter(jwtSecret, this.cookieGenerator, this.userService, this.tokenService, this.authoritiesProvider), BasicAuthenticationFilter.class);
        http.addFilterBefore((Filter)new RecaptchaFilter(this.reCaptchaService, this.objectMapper), TokenAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    private void authenticationManager(HttpSecurity http) throws Exception {
        AuthenticationManagerBuilder auth = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        LOGGER.info("--------------------------------------------------------------");
        LOGGER.info("Management API BasicSecurity Config");
        LOGGER.info("Loading authentication identity providers for Basic authentication");
        List providers = this.authenticationProviderManager.getIdentityProviders().stream().filter(authenticationProvider -> !authenticationProvider.external()).collect(Collectors.toList());
        for (io.gravitee.rest.api.security.authentication.AuthenticationProvider provider : providers) {
            LOGGER.info("Loading authentication provider of type {} at position {}", (Object)provider.type(), (Object)provider.index());
            boolean found = false;
            Collection identityProviders = this.identityProviderManager.getAll();
            for (IdentityProvider identityProvider : identityProviders) {
                AuthenticationProvider authenticationProviderPlugin;
                if (!identityProvider.type().equalsIgnoreCase(provider.type()) || (authenticationProviderPlugin = this.identityProviderManager.loadIdentityProvider(identityProvider.type(), provider.configuration())) == null) continue;
                Object authenticationProvider2 = authenticationProviderPlugin.configure();
                if (authenticationProvider2 instanceof org.springframework.security.authentication.AuthenticationProvider) {
                    auth.authenticationProvider((org.springframework.security.authentication.AuthenticationProvider)authenticationProvider2);
                } else if (authenticationProvider2 instanceof SecurityConfigurer) {
                    auth.apply((SecurityConfigurer)authenticationProvider2);
                }
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.error("No authentication provider found for type: {}", (Object)provider.type());
        }
        LOGGER.info("--------------------------------------------------------------");
    }

    private HttpSecurity authentication(HttpSecurity security) throws Exception {
        return (HttpSecurity)security.httpBasic().authenticationDetailsSource(this.authenticationDetailsSource()).realmName("Gravitee.io Management API").and();
    }

    private HttpSecurity session(HttpSecurity security) throws Exception {
        return (HttpSecurity)security.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and();
    }

    private HttpSecurity authorizations(HttpSecurity security) throws Exception {
        String uriOrgPrefix = "/organizations/**";
        String uriPrefix = uriOrgPrefix + "/environments/**";
        return (HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)security.authorizeHttpRequests().requestMatchers(HttpMethod.GET, new String[]{"/swagger.json"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/openapi.*"})).permitAll().requestMatchers(HttpMethod.OPTIONS, new String[]{"**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/auth/cockpit"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/console/**"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{uriOrgPrefix + "/auth/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/social-identities"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{uriOrgPrefix + "/user/login"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/user/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/users/custom-fields"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{uriOrgPrefix + "/users/registration/**"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{uriOrgPrefix + "/users/**/changePassword"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/users"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/users/**"})).authenticated().requestMatchers(HttpMethod.PUT, new String[]{uriOrgPrefix + "/users/**"})).authenticated().requestMatchers(HttpMethod.DELETE, new String[]{uriOrgPrefix + "/users/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/configuration/rolescopes/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/configuration/custom-user-fields"})).permitAll().requestMatchers(new String[]{uriOrgPrefix + "/configuration/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/search/users"})).authenticated().requestMatchers(HttpMethod.POST, new String[]{uriPrefix + "/auth/**"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{uriPrefix + "/user/login"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/user/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/users/custom-fields"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{uriPrefix + "/users/registration/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/users"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/users/**"})).authenticated().requestMatchers(HttpMethod.PUT, new String[]{uriPrefix + "/users/**"})).authenticated().requestMatchers(HttpMethod.DELETE, new String[]{uriPrefix + "/users/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/rolescopes/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/search/users"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/apis/hooks"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/apis/**"})).authenticated().requestMatchers(HttpMethod.POST, new String[]{uriPrefix + "/apis"})).authenticated().requestMatchers(HttpMethod.POST, new String[]{uriPrefix + "/apis/**"})).authenticated().requestMatchers(HttpMethod.PUT, new String[]{uriPrefix + "/apis/**"})).authenticated().requestMatchers(HttpMethod.DELETE, new String[]{uriPrefix + "/apis/**"})).authenticated().requestMatchers(HttpMethod.POST, new String[]{uriPrefix + "/applications"})).authenticated().requestMatchers(HttpMethod.POST, new String[]{uriPrefix + "/applications/**"})).authenticated().requestMatchers(HttpMethod.PUT, new String[]{uriPrefix + "/applications/**"})).authenticated().requestMatchers(HttpMethod.DELETE, new String[]{uriPrefix + "/applications/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/subscriptions/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/instances/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/platform/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/groups/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/categories/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/tags/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/tenants/**"})).permitAll().requestMatchers(new String[]{uriPrefix + "/configuration/**"})).authenticated().requestMatchers(HttpMethod.GET, new String[]{uriPrefix + "/entrypoints/**"})).permitAll().anyRequest()).authenticated().and();
    }

    private AuthenticationDetailsSource<HttpServletRequest, GraviteeAuthenticationDetails> authenticationDetailsSource() {
        return GraviteeAuthenticationDetails::new;
    }

    private HttpSecurity hsts(HttpSecurity security) throws Exception {
        HeadersConfigurer.HstsConfig hstsConfig = security.headers().httpStrictTransportSecurity();
        Boolean hstsEnabled = (Boolean)this.environment.getProperty("http.hsts.enabled", Boolean.class, (Object)true);
        if (hstsEnabled.booleanValue()) {
            return (HttpSecurity)hstsConfig.includeSubDomains(((Boolean)this.environment.getProperty("http.hsts.include-sub-domains", Boolean.class, (Object)true)).booleanValue()).maxAgeInSeconds(((Long)this.environment.getProperty("http.hsts.max-age", Long.class, (Object)31536000L)).longValue()).and().and();
        }
        return (HttpSecurity)hstsConfig.disable().and();
    }

    private HttpSecurity csrf(HttpSecurity security) throws Exception {
        if (((Boolean)this.environment.getProperty("http.csrf.enabled", Boolean.class, (Object)false)).booleanValue()) {
            CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
            requestHandler.setCsrfRequestAttributeName(null);
            CookieCsrfSignedTokenRepository csrfTokenRepository = this.cookieCsrfSignedTokenRepository();
            return security.csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)csrfTokenRepository).requireCsrfProtectionMatcher((RequestMatcher)new CsrfRequestMatcher()).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler).sessionAuthenticationStrategy((authentication, request, response) -> csrfTokenRepository.saveToken((CsrfToken)request.getAttribute(CsrfToken.class.getName()), request, response))).addFilterAfter((Filter)new CsrfIncludeFilter(), CsrfFilter.class);
        }
        return security.csrf(AbstractHttpConfigurer::disable);
    }

    private HttpSecurity cors(HttpSecurity security) throws Exception {
        return (HttpSecurity)security.cors().and();
    }
}

