/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.AbstractKeyProcessor;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.Algorithm;

public class HMACKeyProcessor<C extends SecurityContext>
extends AbstractKeyProcessor<C> {
    public HMACKeyProcessor(DefaultJWTClaimsVerifier<C> claimsVerifier) {
        super(claimsVerifier);
    }

    @Override
    JWSKeySelector<C> jwsKeySelector(JWKSource<C> jwkSource, Algorithm signature) {
        return new JWSVerificationKeySelector<C>(this, signature.getAlgorithm(), jwkSource){

            protected JWKMatcher createJWKMatcher(JWSHeader jwsHeader) {
                JWSAlgorithm algorithm = jwsHeader.getAlgorithm();
                if (!this.isAllowed(algorithm)) {
                    return null;
                }
                if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)algorithm)) {
                    return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((com.nimbusds.jose.Algorithm)algorithm)).privateOnly(true).algorithms(new com.nimbusds.jose.Algorithm[]{algorithm, null}).build();
                }
                return null;
            }
        };
    }
}

