/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Tag(name="Promotion")
public class PromotionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private PromotionService promotionService;
    @PathParam(value="promotion")
    @Parameter(name="promotion", required=true, description="The ID of the promotion")
    private String promotion;

    @POST
    @Path(value="/_process")
    @Produces(value={"application/json"})
    @Operation(summary="Process an API promotion by accepting or rejecting it")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Processed promotion", content={@Content(mediaType="application/json", schema=@Schema(implementation=PromotionEntity.class))}), @ApiResponse(responseCode="404", description="Promotion not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response processPromotion(boolean accepted) {
        return Response.ok((Object)this.promotionService.processPromotion(GraviteeContext.getExecutionContext(), this.promotion, accepted)).build();
    }
}

