/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.resource.InstanceResource;
import io.gravitee.rest.api.management.rest.resource.param.InstanceSearchParam;
import io.gravitee.rest.api.model.InstanceListItem;
import io.gravitee.rest.api.model.InstanceQuery;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.CloudEnabledException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;

@Tag(name="Gateway")
public class InstancesResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private InstanceService instanceService;
    @Inject
    private ParameterService parameterService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List gateway instances")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_INSTANCE, acls={RolePermissionAction.READ})})
    public Page<InstanceListItem> getInstances(@BeanParam InstanceSearchParam param) {
        if (this.cloudEnabled().booleanValue()) {
            throw new CloudEnabledException();
        }
        InstanceQuery query = new InstanceQuery();
        query.setIncludeStopped(param.isIncludeStopped());
        query.setFrom(param.getFrom().longValue());
        query.setTo(param.getTo().longValue());
        query.setPage(param.getPage().intValue());
        query.setSize(param.getSize().intValue());
        return this.instanceService.search(GraviteeContext.getExecutionContext(), query);
    }

    @Path(value="{instance}")
    public InstanceResource getInstanceResource() {
        return (InstanceResource)this.resourceContext.getResource(InstanceResource.class);
    }

    private Boolean cloudEnabled() {
        return this.parameterService.findAsBoolean(GraviteeContext.getExecutionContext(), Key.CLOUD_HOSTED_ENABLED, GraviteeContext.getCurrentOrganization(), ParameterReferenceType.ORGANIZATION);
    }
}

