/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.node.api.license.License;
import io.gravitee.node.api.license.LicenseManager;
import io.gravitee.rest.api.management.rest.resource.ResourceResource;
import io.gravitee.rest.api.model.ResourceListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ResourceService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(name="Plugins")
public class ResourcesResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private LicenseManager licenseManager;
    @Inject
    private ResourceService resourceService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List resource plugins", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of resources", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ResourceListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<ResourceListItem> getResources(@QueryParam(value="expand") List<String> expand) {
        License license = this.licenseManager.getOrganizationLicenseOrPlatform(GraviteeContext.getCurrentOrganization() != null ? GraviteeContext.getCurrentOrganization() : GraviteeContext.getDefaultOrganization());
        boolean includeSchema = expand.contains("schema");
        boolean includeIcon = expand.contains("icon");
        Stream<ResourceListItem> stream = this.resourceService.findAll().stream().map(resource -> this.convert((PlatformPluginEntity)resource, arg_0 -> ((License)license).isFeatureEnabled(arg_0), includeSchema, includeIcon));
        return stream.sorted(Comparator.comparing(ResourceListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{resource}")
    public ResourceResource getResourceResource() {
        return (ResourceResource)this.resourceContext.getResource(ResourceResource.class);
    }

    private ResourceListItem convert(PlatformPluginEntity resource, Function<String, Boolean> featureEnabled, boolean includeSchema, boolean includeIcon) {
        ResourceListItem item = new ResourceListItem();
        item.setId(resource.getId());
        item.setName(resource.getName());
        item.setDescription(resource.getDescription());
        item.setVersion(resource.getVersion());
        item.setDeployed(Boolean.valueOf(resource.isDeployed() && featureEnabled.apply(resource.getFeature()) != false));
        item.setFeature(resource.getFeature());
        if (includeSchema) {
            item.setSchema(this.resourceService.getSchema(item.getId()));
        }
        if (includeIcon) {
            item.setIcon(this.resourceService.getIcon(item.getId()));
        }
        return item;
    }
}

