/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.InvitationEntity;
import io.gravitee.rest.api.model.InvitationReferenceType;
import io.gravitee.rest.api.model.NewInvitationEntity;
import io.gravitee.rest.api.model.UpdateInvitationEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.InvitationService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.GroupInvitationForbiddenException;
import io.gravitee.rest.api.service.exceptions.GroupMembersLimitationExceededException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;

@Tag(name="Group Invitations")
public class GroupInvitationsResource
extends AbstractResource {
    @Inject
    private InvitationService invitationService;
    @Inject
    private GroupService groupService;
    @Inject
    private UserService userService;
    @PathParam(value="group")
    @Parameter(name="group", hidden=true)
    private String group;

    @GET
    @Operation(summary="List existing invitations of a group", description="User must have the GROUP_INVITATION[READ] permission to use this service")
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ, RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.READ})})
    public List<InvitationEntity> getGroupInvitations() {
        return this.invitationService.findByReference(InvitationReferenceType.GROUP, this.group);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an invitation to join a group", description="User must have the GROUP_INVITATION[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE, RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.CREATE})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Invitation sent successfully", content={@Content(schema=@Schema(implementation=InvitationEntity.class))}), @ApiResponse(responseCode="202", description="Request is accepted and list of users to select and invite sent successfully", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UserEntity.class)))})})
    public Response createGroupInvitation(@Valid @NotNull NewInvitationEntity invitationEntity) {
        List userEntities;
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        GroupEntity groupEntity = this.groupService.findById(executionContext, this.group);
        boolean hasPermission = this.permissionService.hasPermission(executionContext, RolePermission.ENVIRONMENT_GROUP, GraviteeContext.getCurrentEnvironment(), new RolePermissionAction[]{RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE});
        if (!hasPermission) {
            if (groupEntity.getMaxInvitation() != null && this.groupService.getNumberOfMembers(executionContext, this.group) >= groupEntity.getMaxInvitation()) {
                throw new GroupMembersLimitationExceededException(groupEntity.getMaxInvitation().intValue());
            }
            if (!groupEntity.isEmailInvitation()) {
                throw new GroupInvitationForbiddenException(GroupInvitationForbiddenException.Type.EMAIL, this.group);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(userEntities = this.userService.findByEmail(executionContext, invitationEntity.getEmail()))) && userEntities.size() > 1) {
            return Response.accepted((Object)userEntities).build();
        }
        invitationEntity.setReferenceType(InvitationReferenceType.GROUP);
        invitationEntity.setReferenceId(this.group);
        return Response.ok((Object)this.invitationService.create(executionContext, invitationEntity)).build();
    }

    @Path(value="{invitation}")
    @PUT
    @Operation(summary="Update an invitation to join a group", description="User must have the GROUP_INVITATION[UPDATE] permission to use this service")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE, RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.UPDATE})})
    public InvitationEntity updateGroupInvitation(@PathParam(value="invitation") String invitation, @Valid @NotNull UpdateInvitationEntity invitationEntity) {
        invitationEntity.setId(invitation);
        invitationEntity.setReferenceType(InvitationReferenceType.GROUP);
        invitationEntity.setReferenceId(this.group);
        return this.invitationService.update(invitationEntity);
    }

    @Path(value="{invitation}")
    @DELETE
    @Operation(summary="Delete an invitation to join a group", description="User must have the GROUP_INVITATION[DELETE] permission to use this service")
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE, RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.DELETE})})
    public void deleteGroupInvitation(@PathParam(value="invitation") String invitation) {
        this.invitationService.delete(invitation, this.group);
    }
}

