/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.ConnectorResource;
import io.gravitee.rest.api.model.ConnectorListItem;
import io.gravitee.rest.api.model.ConnectorPluginEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ConnectorService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(name="Plugins")
public class ConnectorsResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ConnectorService connectorService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List connector plugins", description="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of connectors", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ConnectorListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<ConnectorListItem> getConnectors(@QueryParam(value="expand") List<String> expand) {
        boolean includeSchema = expand.contains("schema");
        boolean includeIcon = expand.contains("icon");
        Stream<ConnectorListItem> stream = this.connectorService.findAll().stream().map(connector -> this.convert((ConnectorPluginEntity)connector, includeSchema, includeIcon));
        return stream.sorted(Comparator.comparing(ConnectorListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{connector}")
    public ConnectorResource getConnectorResource() {
        return (ConnectorResource)this.resourceContext.getResource(ConnectorResource.class);
    }

    private ConnectorListItem convert(ConnectorPluginEntity connector, boolean includeSchema, boolean includeIcon) {
        ConnectorListItem item = new ConnectorListItem();
        item.setId(connector.getId());
        item.setName(connector.getName());
        item.setDescription(connector.getDescription());
        item.setVersion(connector.getVersion());
        item.setSupportedTypes(connector.getSupportedTypes());
        if (includeSchema) {
            item.setSchema(this.connectorService.getSchema(connector.getId()));
        }
        if (includeIcon) {
            item.setIcon(this.connectorService.getIcon(connector.getId()));
        }
        return item;
    }
}

