/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.exceptions.InvalidKeyException;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks.JWKSourceResolver;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.resolver.PublicKeyResolver;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAJWKSourceResolver<C extends SecurityContext>
implements JWKSourceResolver<C> {
    private final JWK jwk;
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAJWKSourceResolver.class);

    private RSAJWKSourceResolver(String publicKey) {
        if (publicKey == null) {
            throw new InvalidKeyException("Public key can't be null");
        }
        RSAPublicKey rsaPublicKey = null;
        try {
            JWK key = JWK.parseFromPEMEncodedObjects((String)publicKey);
            rsaPublicKey = ((RSAKey)key).toRSAPublicKey();
        }
        catch (JOSEException e) {
            LOGGER.error("unable to parse public key {}", (Object)e.getMessage());
        }
        this.jwk = rsaPublicKey != null ? new RSAKey.Builder(rsaPublicKey).build() : null;
    }

    public RSAJWKSourceResolver(PublicKeyResolver publicKeyResolver) {
        this(publicKeyResolver.resolve());
    }

    @Override
    public JWKSource<C> resolve() {
        try {
            return new ImmutableJWKSet(new JWKSet(this.jwk));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

