/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.PageReferenceType;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.PageNotFoundException;
import io.gravitee.rest.api.service.exceptions.UploadUnauthorized;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Tag(name="API Media")
public class ApiPageMediaResource
extends AbstractResource {
    @Inject
    private MediaService mediaService;
    @Inject
    private PageService pageService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;
    @PathParam(value="page")
    @Parameter(name="page", hidden=true)
    private String page;

    @POST
    @Operation(summary="Attach a media to an API page ", description="User must have the API_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Media successfully added", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediaEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response attachApiPageMedia(@Context HttpServletRequest request, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="file") FormDataBodyPart body, @FormDataParam(value="fileName") String fileName) throws IOException {
        PageEntity currentPage = this.pageService.findById(this.page);
        if (!currentPage.getReferenceType().equalsIgnoreCase(PageReferenceType.API.name()) || !currentPage.getReferenceId().equalsIgnoreCase(this.api)) {
            throw new PageNotFoundException(this.page);
        }
        if ((long)request.getContentLength() > this.mediaService.getMediaMaxSize(GraviteeContext.getExecutionContext())) {
            throw new UploadUnauthorized("Max size is " + this.mediaService.getMediaMaxSize(GraviteeContext.getExecutionContext()) + "bytes. Actual size is " + request.getContentLength() + "bytes.");
        }
        String originalFileName = fileDetail.getFileName();
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setSize(fileDetail.getSize());
        mediaEntity.setType(body.getMediaType().getType());
        mediaEntity.setSubType(body.getMediaType().getSubtype());
        mediaEntity.setData(IOUtils.toByteArray((InputStream)uploadedInputStream));
        mediaEntity.setFileName(originalFileName);
        String mediaId = this.mediaService.saveApiMedia(GraviteeContext.getExecutionContext(), this.api, mediaEntity);
        this.pageService.attachMedia(this.page, mediaId, fileName == null ? originalFileName : fileName).flatMap(pageEntity -> pageEntity.getAttachedMedia().stream().filter(media -> media.getMediaHash().equals(mediaId)).findFirst()).ifPresent(createdMedia -> {
            mediaEntity.setCreateAt(createdMedia.getAttachedAt());
            mediaEntity.setHash(createdMedia.getMediaHash());
        });
        mediaEntity.setData(null);
        URI location = URI.create(this.uriInfo.getPath());
        return Response.created((URI)location).entity((Object)mediaEntity).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve all media for an API page", description="User must have the API_DOCUMENTATION[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.READ})})
    public Response getApiPageMedia() {
        PageEntity currentPage = this.pageService.findById(this.page);
        if (!currentPage.getReferenceType().equalsIgnoreCase(PageReferenceType.API.name()) || !currentPage.getReferenceId().equalsIgnoreCase(this.api)) {
            throw new PageNotFoundException(this.page);
        }
        List pageMedia = this.mediaService.findAllWithoutContent(currentPage.getAttachedMedia(), this.api);
        if (pageMedia != null && !pageMedia.isEmpty()) {
            return Response.ok((Object)pageMedia).build();
        }
        return Response.noContent().build();
    }
}

