/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.quality.ApiQualityRuleEntity;
import io.gravitee.rest.api.model.quality.NewApiQualityRuleEntity;
import io.gravitee.rest.api.model.quality.UpdateApiQualityRuleEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ApiQualityRuleService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;

@Tag(name="API Quality")
public class ApiQualityRulesResource
extends AbstractResource {
    @Inject
    private ApiQualityRuleService apiQualityRuleService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Operation(summary="List quality rules for an API", description="User must have the API_QUALITY_RULE[READ] permission to use this service")
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_QUALITY_RULE, acls={RolePermissionAction.READ})})
    public List<ApiQualityRuleEntity> getApiQualityRules() {
        return this.apiQualityRuleService.findByApi(this.api);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new quality rules for an API", description="User must have the API_QUALITY_RULE[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_QUALITY_RULE, acls={RolePermissionAction.CREATE})})
    public ApiQualityRuleEntity createApiQualityRule(@Valid @NotNull NewApiQualityRuleEntity apiQualityRuleEntity) {
        apiQualityRuleEntity.setApi(this.api);
        return this.apiQualityRuleService.create(GraviteeContext.getExecutionContext(), apiQualityRuleEntity);
    }

    @Path(value="{qualityRule}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an existing quality rules for an API", description="User must have the API_QUALITY_RULE[UPDATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_QUALITY_RULE, acls={RolePermissionAction.UPDATE})})
    public ApiQualityRuleEntity updateApiQualityRule(@PathParam(value="qualityRule") String qualityRule, @Valid @NotNull UpdateApiQualityRuleEntity apiQualityRuleEntity) {
        apiQualityRuleEntity.setApi(this.api);
        apiQualityRuleEntity.setQualityRule(qualityRule);
        return this.apiQualityRuleService.update(GraviteeContext.getExecutionContext(), apiQualityRuleEntity);
    }
}

