/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.notification.NotificationConfigType;
import io.gravitee.rest.api.model.notification.PortalNotificationConfigEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Tag(name="API Notifications")
public class ApiNotificationSettingsResource
extends AbstractResource {
    @Inject
    private PortalNotificationConfigService portalNotificationConfigService;
    @Inject
    private GenericNotificationConfigService genericNotificationConfigService;
    @Inject
    private GroupService groupService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Operation(summary="Get notification settings")
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_NOTIFICATION, acls={RolePermissionAction.READ})})
    public List<Object> getApiNotificationSettings() {
        ArrayList<Object> settings = new ArrayList<Object>();
        settings.add(this.portalNotificationConfigService.findById(this.getAuthenticatedUser(), NotificationReferenceType.API, this.api));
        if (this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_NOTIFICATION, this.api, RolePermissionAction.CREATE, RolePermissionAction.READ, RolePermissionAction.UPDATE, RolePermissionAction.DELETE)) {
            settings.addAll(this.genericNotificationConfigService.findByReference(NotificationReferenceType.API, this.api));
        }
        return settings;
    }

    @POST
    @Operation(summary="Create notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Object createApiNotificationSettings(GenericNotificationConfigEntity config) {
        if (!this.api.equals(config.getReferenceId()) || !NotificationReferenceType.API.name().equals(config.getReferenceType())) {
            throw new ForbiddenAccessException();
        }
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (config.getConfigType().equals((Object)NotificationConfigType.GENERIC) && this.hasPermission(executionContext, RolePermission.API_NOTIFICATION, this.api, RolePermissionAction.CREATE)) {
            return this.genericNotificationConfigService.create(config);
        }
        if (config.getConfigType().equals((Object)NotificationConfigType.PORTAL) && this.hasPermission(executionContext, RolePermission.API_NOTIFICATION, this.api, RolePermissionAction.READ)) {
            PortalNotificationConfigEntity notificationEntity = this.convert(config);
            this.checkGroups(executionContext, notificationEntity);
            return this.portalNotificationConfigService.save(notificationEntity);
        }
        throw new ForbiddenAccessException();
    }

    @PUT
    @Path(value="{notificationId}")
    @Operation(summary="Update generic notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_NOTIFICATION, acls={RolePermissionAction.UPDATE})})
    public GenericNotificationConfigEntity updateApiGeneralNotificationSettings(@PathParam(value="notificationId") String notificationId, GenericNotificationConfigEntity config) {
        if (!(this.api.equals(config.getReferenceId()) && NotificationReferenceType.API.name().equals(config.getReferenceType()) && config.getConfigType().equals((Object)NotificationConfigType.GENERIC) && notificationId.equals(config.getId()))) {
            throw new ForbiddenAccessException();
        }
        return this.genericNotificationConfigService.update(config);
    }

    @PUT
    @Operation(summary="Update portal notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_NOTIFICATION, acls={RolePermissionAction.READ})})
    public PortalNotificationConfigEntity updateApiPortalNotificationSettings(PortalNotificationConfigEntity config) {
        if (!(this.api.equals(config.getReferenceId()) && NotificationReferenceType.API.name().equals(config.getReferenceType()) && config.getConfigType().equals((Object)NotificationConfigType.PORTAL))) {
            throw new ForbiddenAccessException();
        }
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        this.checkGroups(executionContext, config);
        return this.portalNotificationConfigService.save(config);
    }

    @DELETE
    @Path(value="{notificationId}")
    @Operation(summary="Delete notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_NOTIFICATION, acls={RolePermissionAction.DELETE})})
    public Response deleteApiNotificationSettings(@PathParam(value="notificationId") String notificationId) {
        this.genericNotificationConfigService.delete(notificationId);
        return Response.noContent().build();
    }

    private PortalNotificationConfigEntity convert(GenericNotificationConfigEntity generic) {
        PortalNotificationConfigEntity portalNotificationConfigEntity = new PortalNotificationConfigEntity();
        portalNotificationConfigEntity.setConfigType(generic.getConfigType());
        portalNotificationConfigEntity.setReferenceType(generic.getReferenceType());
        portalNotificationConfigEntity.setReferenceId(generic.getReferenceId());
        portalNotificationConfigEntity.setUser(this.getAuthenticatedUser());
        portalNotificationConfigEntity.setHooks(generic.getHooks());
        portalNotificationConfigEntity.setGroups(generic.getGroups());
        return portalNotificationConfigEntity;
    }

    private void checkGroups(ExecutionContext executionContext, PortalNotificationConfigEntity notificationEntity) {
        if (CollectionUtils.isEmpty((Collection)notificationEntity.getGroups())) {
            return;
        }
        String primaryOwnerUserId = this.membershipService.getPrimaryOwnerUserId(executionContext.getOrganizationId(), MembershipReferenceType.API, notificationEntity.getReferenceId());
        if (!Objects.equals(primaryOwnerUserId, this.getAuthenticatedUser())) {
            throw new ForbiddenAccessException();
        }
        GenericApiEntity theAPI = this.apiSearchService.findGenericById(executionContext, this.api);
        if (!theAPI.getGroups().containsAll(notificationEntity.getGroups())) {
            throw new InvalidDataException("One of the groups is not a member of this API, got [%s] expected one of [%s]".formatted(notificationEntity.getGroups(), theAPI.getGroups()));
        }
    }
}

