/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.application.registration;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.configuration.application.registration.ClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.configuration.application.registration.UpdateClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.application.ClientRegistrationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Tag(name="Client Registration Providers")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ClientRegistrationProviderResource
extends AbstractResource {
    @Autowired
    private ClientRegistrationService clientRegistrationService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a client registration provider", description="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A client registration provider", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClientRegistrationProviderEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.READ})})
    public ClientRegistrationProviderEntity getClientRegistrationProvider(@PathParam(value="clientRegistrationProvider") String clientRegistrationProvider) {
        return this.clientRegistrationService.findById(GraviteeContext.getCurrentEnvironment(), clientRegistrationProvider);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a client registration provider", description="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated client registration provider", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClientRegistrationProviderEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.UPDATE})})
    public ClientRegistrationProviderEntity updateClientRegistrationProvider(@PathParam(value="clientRegistrationProvider") String clientRegistrationProvider, @Parameter(name="clientRegistrationProvider", required=true) @Valid @NotNull UpdateClientRegistrationProviderEntity updatedClientRegistrationProvider) {
        return this.clientRegistrationService.update(GraviteeContext.getExecutionContext(), clientRegistrationProvider, updatedClientRegistrationProvider);
    }

    @DELETE
    @Operation(summary="Delete a client registration provider", description="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Client registration provider successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.DELETE})})
    public Response deleteClientRegistrationProvider(@PathParam(value="clientRegistrationProvider") String clientRegistrationProvider) {
        this.clientRegistrationService.delete(GraviteeContext.getExecutionContext(), clientRegistrationProvider);
        return Response.noContent().build();
    }
}

