/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.MonitoringResource;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.CloudEnabledException;
import io.gravitee.rest.api.service.exceptions.InstanceNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Set;

@Tag(name="Gateway")
public class InstanceResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private InstanceService instanceService;
    @Inject
    private ParameterService parameterService;
    @PathParam(value="instance")
    private String instance;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a gateway instance")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_INSTANCE, acls={RolePermissionAction.READ})})
    public InstanceEntity getInstance() {
        if (this.cloudEnabled().booleanValue()) {
            throw new CloudEnabledException();
        }
        InstanceEntity instanceEntity = this.instanceService.findByEvent(GraviteeContext.getExecutionContext(), this.instance);
        if (this.isInstanceAccessibleByEnv(instanceEntity.getEnvironments(), GraviteeContext.getCurrentEnvironment())) {
            return instanceEntity;
        }
        throw new InstanceNotFoundException(this.instance);
    }

    @Path(value="monitoring/{gatewayId}")
    public MonitoringResource getMonitoringResource() {
        return (MonitoringResource)this.resourceContext.getResource(MonitoringResource.class);
    }

    private boolean isInstanceAccessibleByEnv(Set<String> environments, String currentEnvironment) {
        return environments == null || environments.isEmpty() || environments.contains(currentEnvironment);
    }

    private Boolean cloudEnabled() {
        return this.parameterService.findAsBoolean(GraviteeContext.getExecutionContext(), Key.CLOUD_HOSTED_ENABLED, GraviteeContext.getCurrentOrganization(), ParameterReferenceType.ORGANIZATION);
    }
}

