/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.monitoring.MonitoringData;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.MonitoringService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.CloudEnabledException;
import io.gravitee.rest.api.service.exceptions.InstanceNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Set;

@Tag(name="Gateway")
public class MonitoringResource
extends AbstractResource {
    @Inject
    private MonitoringService monitoringService;
    @Inject
    private InstanceService instanceService;
    @Inject
    private EnvironmentService environmentService;
    @Inject
    private ParameterService parameterService;
    @PathParam(value="instance")
    @Parameter(name="instance", hidden=true)
    private String instance;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get monitoring metrics for a gateway instance")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public MonitoringData getInstanceMonitoring(@PathParam(value="gatewayId") String gatewayId) {
        if (this.cloudEnabled().booleanValue()) {
            throw new CloudEnabledException();
        }
        InstanceEntity instanceEntity = this.instanceService.findByEvent(GraviteeContext.getExecutionContext(), this.instance);
        if (!this.isInstanceAccessibleByEnv(instanceEntity.getEnvironments(), GraviteeContext.getCurrentEnvironment()) || !this.isInstanceAccessibleByOrga(instanceEntity.getEnvironments(), GraviteeContext.getCurrentOrganization())) {
            throw new InstanceNotFoundException(this.instance);
        }
        return this.monitoringService.findMonitoring(GraviteeContext.getExecutionContext(), gatewayId);
    }

    private boolean isInstanceAccessibleByOrga(Set<String> environmentIds, String currentOrganization) {
        if (environmentIds == null || environmentIds.isEmpty()) {
            return true;
        }
        return this.environmentService.findOrganizationIdsByEnvironments(environmentIds).stream().anyMatch(id -> id.equalsIgnoreCase(currentOrganization));
    }

    private boolean isInstanceAccessibleByEnv(Set<String> environments, String currentEnvironment) {
        return environments == null || environments.isEmpty() || environments.contains(currentEnvironment);
    }

    private Boolean cloudEnabled() {
        return this.parameterService.findAsBoolean(GraviteeContext.getExecutionContext(), Key.CLOUD_HOSTED_ENABLED, GraviteeContext.getCurrentOrganization(), ParameterReferenceType.ORGANIZATION);
    }
}

