/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.provider;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.management.rest.provider.AbstractExceptionMapper;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ConstraintValidationExceptionMapper
extends AbstractExceptionMapper<ConstraintViolationException> {
    public Response toResponse(ConstraintViolationException cve) {
        Response.Status error = Response.Status.BAD_REQUEST;
        return Response.status((Response.Status)error).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ConstraintValidationError(cve)).build();
    }

    static class ConstraintValidationError {
        private final String message;
        private final String path;
        @JsonProperty(value="invalid_value")
        private final Object invalidValue;
        private final List<ConstraintViolationDetail> details;

        ConstraintValidationError(ConstraintViolationException cve) {
            ConstraintViolation violation = (ConstraintViolation)cve.getConstraintViolations().iterator().next();
            this.message = violation.getMessage();
            this.path = violation.getPropertyPath().toString();
            this.invalidValue = violation.getInvalidValue();
            this.details = cve.getConstraintViolations().stream().map(constraintViolation -> ConstraintViolationDetail.builder().message(constraintViolation.getMessage()).location(this.extractLocation((ConstraintViolation<?>)constraintViolation)).invalidValue(constraintViolation.getInvalidValue()).build()).toList();
        }

        private String extractLocation(ConstraintViolation<?> constraintViolation) {
            String errorLocation = constraintViolation.getPropertyPath().toString();
            return errorLocation.substring(StringUtils.ordinalIndexOf((CharSequence)errorLocation, (CharSequence)".", (int)2) + 1);
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public Object getInvalidValue() {
            return this.invalidValue;
        }

        @Generated
        public List<ConstraintViolationDetail> getDetails() {
            return this.details;
        }
    }

    record ConstraintViolationDetail(String message, String location, Object invalidValue) {
        @Generated
        public static ConstraintViolationDetailBuilder builder() {
            return new ConstraintViolationDetailBuilder();
        }

        @Generated
        public static class ConstraintViolationDetailBuilder {
            @Generated
            private String message;
            @Generated
            private String location;
            @Generated
            private Object invalidValue;

            @Generated
            ConstraintViolationDetailBuilder() {
            }

            @Generated
            public ConstraintViolationDetailBuilder message(String message) {
                this.message = message;
                return this;
            }

            @Generated
            public ConstraintViolationDetailBuilder location(String location) {
                this.location = location;
                return this;
            }

            @Generated
            public ConstraintViolationDetailBuilder invalidValue(Object invalidValue) {
                this.invalidValue = invalidValue;
                return this;
            }

            @Generated
            public ConstraintViolationDetail build() {
                return new ConstraintViolationDetail(this.message, this.location, this.invalidValue);
            }

            @Generated
            public String toString() {
                return "ConstraintValidationExceptionMapper.ConstraintViolationDetail.ConstraintViolationDetailBuilder(message=" + this.message + ", location=" + this.location + ", invalidValue=" + String.valueOf(this.invalidValue) + ")";
            }
        }
    }
}

