/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.AbstractKeyProcessor;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.Algorithm;

public class RSAECKeyProcessor<C extends SecurityContext>
extends AbstractKeyProcessor<C> {
    public RSAECKeyProcessor(DefaultJWTClaimsVerifier<C> claimsVerifier) {
        super(claimsVerifier);
    }

    @Override
    JWSKeySelector<C> jwsKeySelector(JWKSource<C> jwkSource, Algorithm signature) {
        return new JWSVerificationKeySelector<C>(signature.getAlgorithm(), jwkSource){

            protected JWKMatcher createJWKMatcher(JWSHeader jwsHeader) {
                JWSAlgorithm algorithm = jwsHeader.getAlgorithm();
                if (!this.isAllowed(algorithm)) {
                    return null;
                }
                if (JWSAlgorithm.Family.RSA.contains((Object)algorithm) || JWSAlgorithm.Family.EC.contains((Object)algorithm)) {
                    return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((com.nimbusds.jose.Algorithm)algorithm)).keyUses(new KeyUse[]{KeyUse.SIGNATURE, null}).algorithms(new com.nimbusds.jose.Algorithm[]{algorithm, null}).x509CertSHA256Thumbprint(jwsHeader.getX509CertSHA256Thumbprint()).build();
                }
                return null;
            }
        };
    }
}

