/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.apim.core.api.exception.InvalidPathsException;
import io.gravitee.apim.core.api.model.Path;
import io.gravitee.apim.core.api.use_case.VerifyApiPathsUseCase;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.data.domain.Page;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.PagedResult;
import io.gravitee.rest.api.management.rest.model.wrapper.ApiListItemPagedResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiMediaResource;
import io.gravitee.rest.api.management.rest.resource.ApiResource;
import io.gravitee.rest.api.management.rest.resource.ApisOrderParam;
import io.gravitee.rest.api.management.rest.resource.param.ApisParam;
import io.gravitee.rest.api.management.rest.resource.param.VerifyApiParam;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.RatingSummaryEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiCRDEntity;
import io.gravitee.rest.api.model.api.ApiCRDStatusEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.ApiListItem;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.api.ApiValidationResult;
import io.gravitee.rest.api.model.api.NewApiEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ApiCRDService;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApiValidationService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.RatingService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.exceptions.ApiAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.Hook;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;

@Tag(name="APIs")
public class ApisResource
extends AbstractResource {
    @Inject
    protected ApiDuplicatorService apiDuplicatorService;
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApiService apiService;
    @Inject
    private ApiCRDService apiCRDService;
    @Inject
    @Qualifier(value="apiV2ValidationService")
    private ApiValidationService apiValidationService;
    @Inject
    private SwaggerService swaggerService;
    @Inject
    private TopApiService topApiService;
    @Inject
    private RatingService ratingService;
    @Inject
    private CategoryService categoryService;
    @Inject
    private FlowService flowService;
    @Inject
    private VerifyApiPathsUseCase verifyApiPathsUsecase;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List APIs", description="List all the APIs accessible to the current user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List accessible APIs for current user", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApiListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Collection<ApiListItem> getApis(@BeanParam ApisParam apisParam, @QueryParam(value="ids") List<String> ids) {
        return this.getApis(apisParam, ids, null).getData();
    }

    @GET
    @jakarta.ws.rs.Path(value="_paged")
    @Produces(value={"application/json"})
    @Operation(summary="List APIs with pagination", description="List all the APIs accessible to the current user with pagination.", operationId="getApisPaged")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page of APIs for current user", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiListItemPagedResult.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public ApiListItemPagedResult getApis(@BeanParam ApisParam apisParam, @QueryParam(value="ids") List<String> ids, @Valid @BeanParam Pageable pageable) {
        Page apis;
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiQuery apiQuery = new ApiQuery();
        if (ids != null && !ids.isEmpty()) {
            apiQuery.setIds(ids);
        }
        if (apisParam.getGroup() != null) {
            apiQuery.setGroups(Collections.singletonList(apisParam.getGroup()));
        }
        apiQuery.setContextPath(apisParam.getContextPath());
        apiQuery.setLabel(apisParam.getLabel());
        apiQuery.setVersion(apisParam.getVersion());
        apiQuery.setName(apisParam.getName());
        apiQuery.setTag(apisParam.getTag());
        apiQuery.setState(apisParam.getState());
        apiQuery.setCrossId(apisParam.getCrossId());
        if (apisParam.getCategory() != null) {
            apiQuery.setCategory(this.categoryService.findById(apisParam.getCategory(), executionContext.getEnvironmentId()).getId());
        }
        SortableImpl sortable = null;
        if (apisParam.getOrder() != null) {
            sortable = new SortableImpl(apisParam.getOrder().getField(), apisParam.getOrder().isOrder());
        }
        io.gravitee.rest.api.model.common.Pageable commonPageable = null;
        if (pageable != null) {
            commonPageable = pageable.toPageable();
        }
        if (this.isAdmin()) {
            apis = this.apiService.search(executionContext, apiQuery, (Sortable)sortable, commonPageable);
        } else {
            if (apisParam.isPortal() || apisParam.isTop()) {
                apiQuery.setLifecycleStates(Collections.singletonList(ApiLifecycleState.PUBLISHED));
            }
            if (this.isAuthenticated()) {
                apis = this.apiService.findByUser(executionContext, this.getAuthenticatedUser(), apiQuery, (Sortable)sortable, commonPageable, !apisParam.isPortal());
            } else {
                apiQuery.setVisibility(Visibility.PUBLIC);
                apis = this.apiService.search(executionContext, apiQuery, (Sortable)sortable, commonPageable);
            }
        }
        boolean isRatingServiceEnabled = this.ratingService.isEnabled(executionContext);
        if (apisParam.isTop()) {
            List visibleApis = apis.getContent().stream().map(ApiEntity::getId).collect(Collectors.toList());
            return new ApiListItemPagedResult(this.topApiService.findAll(executionContext).stream().filter(topApi -> visibleApis.contains(topApi.getApi())).map(topApiEntity -> this.apiService.findById(executionContext, topApiEntity.getApi())).map(apiEntity -> this.convert((ApiEntity)apiEntity, isRatingServiceEnabled)).collect(Collectors.toList()), apis.getPageNumber(), (int)apis.getPageElements(), (int)apis.getTotalElements());
        }
        return new ApiListItemPagedResult(apis.getContent().stream().map(apiEntity -> this.convert((ApiEntity)apiEntity, isRatingServiceEnabled)).collect(Collectors.toList()), apis.getPageNumber(), (int)apis.getPageElements(), (int)apis.getTotalElements());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Create an API", description="User must have API_PUBLISHER or ADMIN role to create an API.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="API successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response createApi(@Parameter(name="api", required=true) @Valid @NotNull NewApiEntity newApiEntity) throws ApiAlreadyExistsException {
        ApiEntity newApi = this.apiService.create(GraviteeContext.getExecutionContext(), newApiEntity, this.getAuthenticatedUser());
        if (newApi != null) {
            return Response.created((URI)this.getLocationHeader(newApi.getId())).entity((Object)newApi).build();
        }
        return Response.serverError().build();
    }

    @POST
    @jakarta.ws.rs.Path(value="import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an API by importing an API definition", description="Create an API by importing an existing API definition in JSON format.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.UPDATE})})
    public Response importApiDefinition(@RequestBody(required=true) @Valid @NotNull JsonNode apiDefinition, @QueryParam(value="definitionVersion") @DefaultValue(value="2.0.0") String definitionVersion) {
        return this.importApiDefinitionOrUrl(apiDefinition, definitionVersion);
    }

    @POST
    @jakarta.ws.rs.Path(value="import-url")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an API by importing a URL pointing to an API definition", description="Create an API by importing an existing API definition via a URL")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.UPDATE})})
    public Response importApiDefinitionUrl(@RequestBody(required=true) @Valid @NotNull String apiDefinitionOrUrl, @QueryParam(value="definitionVersion") @DefaultValue(value="2.0.0") String definitionVersion) {
        return this.importApiDefinitionOrUrl(apiDefinitionOrUrl, definitionVersion);
    }

    @PUT
    @jakarta.ws.rs.Path(value="import-crd")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an API by importing an API CRD definition", description="Create an API by importing an API CRD definition")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.UPDATE})})
    public Response importApiDefinitionCrd(@RequestBody(required=true) @Valid @NotNull ApiCRDEntity api, @QueryParam(value="dryRun") boolean dryRun) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiValidationResult validationResult = this.apiValidationService.validateAndSanitizeApiDefinitionCRD(executionContext, api);
        if (dryRun) {
            return Response.ok((Object)new ApiCRDStatusEntity(executionContext.getOrganizationId(), executionContext.getEnvironmentId(), api.getId(), api.getCrossId(), api.getState(), validationResult, Map.of())).build();
        }
        if (CollectionUtils.isNotEmpty((Collection)validationResult.getSevere())) {
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)validationResult).build();
        }
        ApiCRDStatusEntity response = this.apiCRDService.importApiDefinitionCRD(executionContext, (ApiCRDEntity)validationResult.getSanitizedApi());
        response.setErrors(validationResult);
        return Response.ok((Object)response).build();
    }

    @Deprecated(since="3.18.0", forRemoval=true)
    @POST
    @jakarta.ws.rs.Path(value="import")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @Operation(summary="Deprecated - Create an API by importing an API definition", description="Old endpoint to create an API by importing an existing API definition via a URL - prefer `/apis/import-url`")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.UPDATE})})
    public Response deprecatedImportApiDefinitionUrl(@RequestBody(required=true) @Valid @NotNull String apiDefinitionOrUrl, @QueryParam(value="definitionVersion") @DefaultValue(value="2.0.0") String definitionVersion) {
        return this.importApiDefinitionOrUrl(apiDefinitionOrUrl, definitionVersion);
    }

    private Response importApiDefinitionOrUrl(Object apiDefinitionOrUrl, String definitionVersion) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiEntity imported = this.apiDuplicatorService.createWithImportedDefinition(executionContext, apiDefinitionOrUrl);
        if (DefinitionVersion.valueOfLabel((String)definitionVersion).equals((Object)DefinitionVersion.V2) && DefinitionVersion.V1.getLabel().equals(imported.getGraviteeDefinitionVersion())) {
            return Response.ok((Object)this.apiService.migrate(executionContext, imported.getId())).build();
        }
        return Response.ok((Object)imported).build();
    }

    @POST
    @jakarta.ws.rs.Path(value="import/swagger")
    @Produces(value={"application/json"})
    @Operation(summary="Create an API definition from a Swagger descriptor")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="API definition from Swagger descriptor", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response importSwaggerApi(@Parameter(name="swagger", required=true) @Valid @NotNull ImportSwaggerDescriptorEntity swaggerDescriptor, @QueryParam(value="definitionVersion") @DefaultValue(value="2.0.0") String definitionVersion) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        SwaggerApiEntity swaggerApiEntity = this.swaggerService.createAPI(executionContext, swaggerDescriptor, DefinitionVersion.valueOfLabel((String)definitionVersion));
        ApiEntity api = this.apiService.createFromSwagger(executionContext, swaggerApiEntity, this.getAuthenticatedUser(), swaggerDescriptor);
        return Response.created((URI)URI.create(this.uriInfo.getRequestUri().getRawPath().replaceAll("import/swagger", "") + api.getId())).entity((Object)api).build();
    }

    @POST
    @jakarta.ws.rs.Path(value="verify")
    @Consumes(value={"application/json"})
    @Operation(summary="Check if an API match the following criteria", deprecated=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="No API match the following criteria", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}), @ApiResponse(responseCode="400", description="API already exist with the following criteria")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE, RolePermissionAction.UPDATE})})
    @Deprecated
    public Response verifyApi(@Valid VerifyApiParam verifyApiParam) {
        try {
            this.verifyApiPathsUsecase.execute(new VerifyApiPathsUseCase.Request(verifyApiParam.getApiId(), List.of(Path.builder().path(verifyApiParam.getContextPath()).build())));
            return Response.ok((Object)("API context [" + verifyApiParam.getContextPath() + "] is available")).build();
        }
        catch (InvalidPathsException e) {
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)e.getMessage()).build();
        }
    }

    @GET
    @jakarta.ws.rs.Path(value="/hooks")
    @Operation(summary="Get the list of available hooks")
    @Produces(value={"application/json"})
    public Hook[] getApiHooks() {
        return (Hook[])Arrays.stream(ApiHook.values()).filter(h -> !h.isHidden()).toArray(Hook[]::new);
    }

    @POST
    @jakarta.ws.rs.Path(value="_search")
    @Produces(value={"application/json"})
    @Operation(summary="Search for API using the search engine")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List accessible APIs for current user", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApiListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response searchApis(@Parameter(name="q", required=true) @NotNull @QueryParam(value="q") String query) {
        try {
            return Response.ok().entity(this.searchPagedApis(query, new ApisOrderParam("name"), true, null).getData()).build();
        }
        catch (TechnicalManagementException te) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)te).build();
        }
    }

    @POST
    @jakarta.ws.rs.Path(value="_search/_paged")
    @Produces(value={"application/json"})
    @Operation(summary="Search for API using the search engine")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List accessible APIs for current user", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiListItem.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public PagedResult<ApiListItem> searchPagedApis(@Parameter(name="q", required=true) @NotNull @QueryParam(value="q") String query, @Parameter(name="order", schema=@Schema(implementation=String.class, description="By default, sort is ASC. If *field* starts with '-', the order sort is DESC. Currently, only **name** and **paths** are supported")) @QueryParam(value="order") ApisOrderParam apisOrderParam, @Parameter(name="manageOnly", description="By default only APIs that the user can manage are returned. If set to false, all APIs that the user can view are returned.") @QueryParam(value="manageOnly") @DefaultValue(value="true") boolean manageOnly, @Valid @BeanParam Pageable pageable) {
        HashMap<String, Set> filters = new HashMap<String, Set>();
        io.gravitee.rest.api.model.common.Pageable commonPageable = null;
        if (pageable != null) {
            commonPageable = pageable.toPageable();
        }
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (!this.isAdmin()) {
            filters.put("api", this.apiAuthorizationService.findIdsByUser(executionContext, this.getAuthenticatedUser(), manageOnly));
        }
        boolean isRatingServiceEnabled = this.ratingService.isEnabled(executionContext);
        Page apis = this.apiService.search(executionContext, query, filters, apisOrderParam != null ? apisOrderParam.toSortable() : null, commonPageable);
        return new PagedResult<ApiListItem>(apis.getContent().stream().map(apiEntity -> this.convert((ApiEntity)apiEntity, isRatingServiceEnabled)).collect(Collectors.toList()), apis.getPageNumber(), (int)apis.getPageElements(), (int)apis.getTotalElements());
    }

    @PUT
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Path(value="import")
    @Operation(summary="Update the API from the API definition", description="Update the API from the API definition in JSON format either with json or via an URL")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated from API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateWithDefinition(@RequestBody(required=true) @Valid @NotNull Object apiDefinitionOrUrl) {
        ApiEntity updatedApi = this.apiDuplicatorService.updateWithImportedDefinition(GraviteeContext.getExecutionContext(), apiDefinitionOrUrl);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @jakarta.ws.rs.Path(value="{api}")
    public ApiResource getApiResource() {
        return (ApiResource)this.resourceContext.getResource(ApiResource.class);
    }

    @jakarta.ws.rs.Path(value="{api}/media")
    public ApiMediaResource getApiMediaResource() {
        return (ApiMediaResource)this.resourceContext.getResource(ApiMediaResource.class);
    }

    private ApiListItem convert(ApiEntity api, boolean isRatingServiceEnabled) {
        ApiListItem apiItem = new ApiListItem();
        apiItem.setId(api.getId());
        apiItem.setName(api.getName());
        apiItem.setVersion(api.getVersion());
        apiItem.setDescription(api.getDescription());
        UriBuilder ub = this.uriInfo.getBaseUriBuilder();
        UriBuilder uriBuilder = ub.path("organizations").path(GraviteeContext.getCurrentOrganization()).path("environments").path(GraviteeContext.getCurrentEnvironment()).path("apis").path(api.getId()).path("picture");
        uriBuilder.queryParam("hash", new Object[]{api.getUpdatedAt().getTime()});
        apiItem.setPictureUrl(uriBuilder.build(new Object[0]).toString());
        apiItem.setCategories(api.getCategories());
        apiItem.setCreatedAt(api.getCreatedAt());
        apiItem.setUpdatedAt(api.getUpdatedAt());
        apiItem.setLabels(api.getLabels());
        apiItem.setPrimaryOwner(api.getPrimaryOwner());
        apiItem.setHasHealthCheckEnabled(this.apiService.hasHealthCheckEnabled(api, false));
        if (api.getVisibility() != null) {
            apiItem.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if (api.getState() != null) {
            apiItem.setState(Lifecycle.State.valueOf((String)api.getState().toString()));
        }
        if (api.getProxy() != null) {
            apiItem.setVirtualHosts(api.getProxy().getVirtualHosts());
        }
        if (isRatingServiceEnabled) {
            RatingSummaryEntity ratingSummary = this.ratingService.findSummaryByApi(GraviteeContext.getExecutionContext(), api.getId());
            apiItem.setRate(ratingSummary.getAverageRate());
            apiItem.setNumberOfRatings(ratingSummary.getNumberOfRatings());
        }
        apiItem.setTags(api.getTags());
        if (api.getLifecycleState() != null) {
            apiItem.setLifecycleState(ApiLifecycleState.valueOf((String)api.getLifecycleState().toString()));
        }
        if (api.getWorkflowState() != null) {
            apiItem.setWorkflowState(WorkflowState.valueOf((String)api.getWorkflowState().toString()));
        }
        if (api.getProxy().getVirtualHosts() != null && !api.getProxy().getVirtualHosts().isEmpty()) {
            apiItem.setContextPath(((VirtualHost)api.getProxy().getVirtualHosts().get(0)).getPath());
        }
        if (api.getDefinitionContext() != null && !api.getDefinitionContext().getOrigin().isEmpty()) {
            apiItem.setDefinitionContext(api.getDefinitionContext());
        }
        if (api.getDefinitionVersion() != null) {
            apiItem.setGraviteeDefinitionVersion(api.getDefinitionVersion().getLabel());
        }
        return apiItem;
    }

    @GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Path(value="schema")
    @Operation(summary="Get the API configuration schema")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API definition", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Response getApiFlowSchemaForm() {
        return Response.ok((Object)this.flowService.getApiFlowSchemaForm()).build();
    }
}

