/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.el.spel.function.json.JsonPathFunction;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.model.ExchangePayloadEntity;
import io.gravitee.rest.api.management.rest.model.PayloadInput;
import io.gravitee.rest.api.management.rest.resource.auth.AbstractAuthenticationResource;
import io.gravitee.rest.api.management.rest.utils.BlindTrustManager;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.model.configuration.identity.SocialIdentityProviderEntity;
import io.gravitee.rest.api.security.utils.AuthoritiesProvider;
import io.gravitee.rest.api.service.SocialIdentityProviderService;
import io.gravitee.rest.api.service.builder.JerseyClientBuilder;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Singleton
@Tag(name="Authentication")
public class OAuth2AuthenticationResource
extends AbstractAuthenticationResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2AuthenticationResource.class);
    private static final String TEMPLATE_ENGINE_PROFILE_ATTRIBUTE = "profile";
    private static final String ACCESS_TOKEN_PROPERTY = "access_token";
    private static final String ID_TOKEN_PROPERTY = "id_token";
    @Autowired
    private SocialIdentityProviderService socialIdentityProviderService;
    @Autowired
    private Environment environment;
    @Autowired
    private AuthoritiesProvider authoritiesProvider;
    private Client client;

    @PostConstruct
    public void initClient() throws NoSuchAlgorithmException, KeyManagementException {
        boolean trustAllEnabled = (Boolean)this.environment.getProperty("security.trustAll", Boolean.class, (Object)false);
        ClientBuilder builder = JerseyClientBuilder.newBuilder((Environment)this.environment);
        if (trustAllEnabled) {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, new TrustManager[]{new BlindTrustManager()}, null);
            builder.sslContext(sc);
        }
        this.client = builder.build();
    }

    @POST
    @Path(value="exchange")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response tokenExchange(@PathParam(value="identity") String identity, @QueryParam(value="token") String tokenQueryParam, @Valid ExchangePayloadEntity exchangePayload, @Context HttpServletResponse servletResponse) throws IOException {
        String token = tokenQueryParam == null ? exchangePayload.getToken() : tokenQueryParam;
        SocialIdentityProviderEntity identityProvider = this.socialIdentityProviderService.findById(identity, new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION));
        if (identityProvider != null) {
            if (identityProvider.getTokenIntrospectionEndpoint() != null) {
                MultivaluedStringMap introspectData = new MultivaluedStringMap();
                introspectData.add((Object)"token", (Object)token);
                Response response = this.client.target(identityProvider.getTokenIntrospectionEndpoint()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Basic %s", Base64.getEncoder().encodeToString((identityProvider.getClientId() + ":" + identityProvider.getClientSecret()).getBytes()))).post(Entity.form((MultivaluedMap)introspectData));
                introspectData.clear();
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    JsonNode introspectPayload = (JsonNode)response.readEntity(JsonNode.class);
                    boolean active = introspectPayload.path("active").asBoolean(true);
                    if (active) {
                        return this.authenticateUser(identityProvider, servletResponse, token, null, null);
                    }
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)introspectPayload).build();
                }
                LOGGER.error("Token exchange failed with status {}: {}\n{}", new Object[]{response.getStatus(), response.getStatusInfo(), this.getResponseEntityAsString(response)});
                return Response.status((Response.StatusType)response.getStatusInfo()).entity(response.getEntity()).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Token exchange is not supported for this identity provider").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response exchangeAuthorizationCode(@PathParam(value="identity") String identity, @Valid @NotNull PayloadInput payloadInput, @Context HttpServletResponse servletResponse) throws IOException {
        SocialIdentityProviderEntity identityProvider = this.socialIdentityProviderService.findById(identity, new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION));
        if (identityProvider != null) {
            MultivaluedStringMap accessData = new MultivaluedStringMap();
            accessData.add((Object)"client_id", (Object)payloadInput.getClient_id());
            accessData.add((Object)"redirect_uri", (Object)payloadInput.getRedirect_uri());
            accessData.add((Object)"client_secret", (Object)identityProvider.getClientSecret());
            accessData.add((Object)"code", (Object)payloadInput.getCode());
            accessData.add((Object)"code_verifier", (Object)payloadInput.getCode_verifier());
            accessData.add((Object)"grant_type", (Object)"authorization_code");
            Response response = this.client.target(identityProvider.getTokenEndpoint()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.form((MultivaluedMap)accessData));
            accessData.clear();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                Map<String, Object> responseEntity = this.getResponseEntity(response);
                String accessToken = (String)responseEntity.get(ACCESS_TOKEN_PROPERTY);
                String idToken = (String)responseEntity.get(ID_TOKEN_PROPERTY);
                return this.authenticateUser(identityProvider, servletResponse, accessToken, idToken, payloadInput.getState());
            }
            LOGGER.error("Exchange authorization code failed with status {}: {}\n{}", new Object[]{response.getStatus(), response.getStatusInfo(), this.getResponseEntityAsString(response)});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Response authenticateUser(SocialIdentityProviderEntity socialProvider, HttpServletResponse servletResponse, String accessToken, String idToken, String state) throws IOException {
        Response response = this.client.target(socialProvider.getUserInfoEndpoint()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format(socialProvider.getAuthorizationHeader(), accessToken)).get();
        String userInfo = this.getResponseEntityAsString(response);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.processUser(socialProvider, servletResponse, userInfo, state, accessToken, idToken);
        }
        LOGGER.error("User info failed with status {}: {}\n{}", new Object[]{response.getStatus(), response.getStatusInfo(), userInfo});
        return Response.status((Response.StatusType)response.getStatusInfo()).build();
    }

    private Response processUser(SocialIdentityProviderEntity socialProvider, HttpServletResponse servletResponse, String userInfo, String state, String accessToken, String idToken) {
        UserEntity user = this.userService.createOrUpdateUserFromSocialIdentityProvider(GraviteeContext.getExecutionContext(), socialProvider, userInfo);
        Set authorities = this.authoritiesProvider.retrieveAuthorities(user.getId());
        UserDetails userDetails = new UserDetails(user.getId(), "", (Collection)authorities);
        userDetails.setEmail(user.getEmail());
        userDetails.setOrganizationId(user.getOrganizationId());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, null, (Collection)authorities));
        return this.connectUser(user.getId(), state, servletResponse, accessToken, idToken);
    }

    static {
        try {
            LOGGER.trace("Loading class to initialize properly JsonPath Cache provider: " + Class.forName(JsonPathFunction.class.getName()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

