/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.management.rest.model.GroupMembership;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.PagedResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.GroupMemberResource;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.GroupMemberEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MemberRoleEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.alert.ApplicationAlertEventType;
import io.gravitee.rest.api.model.alert.ApplicationAlertMembershipEvent;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.GroupInvitationForbiddenException;
import io.gravitee.rest.api.service.exceptions.GroupMembersLimitationExceededException;
import io.gravitee.rest.api.service.notification.PortalHook;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Tag(name="Group Memberships")
public class GroupMembersResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private GroupService groupService;
    @Inject
    private UserService userService;
    @Inject
    private NotifierService notifierService;
    @Inject
    private EventManager eventManager;
    @PathParam(value="group")
    @Parameter(name="group", hidden=true)
    private String group;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List group members")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of group's members", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GroupMemberEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.READ})})
    public List<GroupMemberEntity> getGroupMembers() {
        return new ArrayList<GroupMemberEntity>(this.getGroupMembers(null).getData());
    }

    @GET
    @Path(value="_paged")
    @Produces(value={"application/json"})
    @Operation(summary="List group members with pagination")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of group's members", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GroupMemberEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.READ})})
    public PagedResult<GroupMemberEntity> getGroupMembers(@Valid @BeanParam Pageable pageable) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        this.groupService.findById(executionContext, this.group);
        io.gravitee.rest.api.model.common.Pageable commonPageable = null;
        if (pageable != null) {
            commonPageable = pageable.toPageable();
        }
        Page membersPage = this.membershipService.getMembersByReference(executionContext, MembershipReferenceType.GROUP, this.group, commonPageable);
        Map<String, List<MemberEntity>> members = membersPage.getContent().stream().filter(Objects::nonNull).collect(Collectors.groupingBy(MemberEntity::getId));
        List groupMemberEntities = members.keySet().stream().map(id -> new GroupMemberEntity((MemberEntity)((List)members.get(id)).get(0))).sorted(Comparator.comparing(GroupMemberEntity::getId)).collect(Collectors.toList());
        return new PagedResult<GroupMemberEntity>(groupMemberEntities, membersPage.getPageNumber(), (int)membersPage.getPageElements(), (int)membersPage.getTotalElements());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Add or update a group member")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Member has been added"), @ApiResponse(responseCode="200", description="Member has been updated"), @ApiResponse(responseCode="400", description="Membership is not valid"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response addOrUpdateGroupMember(@Valid @NotNull List<GroupMembership> memberships) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        GroupEntity groupEntity = this.groupService.findById(executionContext, this.group);
        boolean hasPermission = this.permissionService.hasPermission(executionContext, RolePermission.ENVIRONMENT_GROUP, GraviteeContext.getCurrentEnvironment(), new RolePermissionAction[]{RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE});
        if (!hasPermission) {
            if (groupEntity.getMaxInvitation() != null) {
                Set members = this.membershipService.getMembersByReference(executionContext, MembershipReferenceType.GROUP, this.group);
                long membershipsToAddSize = memberships.stream().map(GroupMembership::getId).filter(s -> {
                    List<String> membershipIdsToSave = members.stream().map(MemberEntity::getId).toList();
                    return !membershipIdsToSave.contains(s);
                }).count();
                if ((long)this.groupService.getNumberOfMembers(executionContext, this.group) + membershipsToAddSize > (long)groupEntity.getMaxInvitation().intValue()) {
                    throw new GroupMembersLimitationExceededException(groupEntity.getMaxInvitation().intValue());
                }
            }
            if (!groupEntity.isSystemInvitation()) {
                throw new GroupInvitationForbiddenException(GroupInvitationForbiddenException.Type.SYSTEM, this.group);
            }
        }
        for (GroupMembership membership : memberships) {
            RoleEntity groupRoleEntity;
            RoleEntity integrationRoleEntity;
            RoleEntity applicationRoleEntity;
            RoleEntity previousApiRole = null;
            RoleEntity previousApplicationRole = null;
            RoleEntity previousGroupRole = null;
            RoleEntity previousIntegrationRole = null;
            if (membership.getId() != null) {
                Set userRoles = this.membershipService.getRoles(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, membership.getId());
                for (RoleEntity role : userRoles) {
                    switch (role.getScope()) {
                        case API: {
                            previousApiRole = role;
                            break;
                        }
                        case APPLICATION: {
                            previousApplicationRole = role;
                            break;
                        }
                        case GROUP: {
                            previousGroupRole = role;
                            break;
                        }
                        case INTEGRATION: {
                            previousIntegrationRole = role;
                            break;
                        }
                    }
                }
            }
            if (membership.getRoles() == null || membership.getRoles().isEmpty()) continue;
            HashMap roleEntities = new HashMap();
            for (MemberRoleEntity item : membership.getRoles()) {
                this.roleService.findByScopeAndName(item.getRoleScope(), item.getRoleName(), GraviteeContext.getCurrentOrganization()).ifPresent(roleEntity -> roleEntities.put(item.getRoleScope(), roleEntity));
            }
            MemberEntity updatedMembership = null;
            RoleEntity apiRoleEntity = (RoleEntity)roleEntities.get(RoleScope.API);
            if (apiRoleEntity != null && !apiRoleEntity.equals((Object)previousApiRole)) {
                String roleName = this.getRoleName(RoleScope.API, apiRoleEntity, groupEntity, GroupEntity::isLockApiRole, hasPermission);
                updatedMembership = this.updateRole(RoleScope.API, roleName, previousApiRole, membership, executionContext);
                if (previousApiRole != null && previousApiRole.getName().equals(SystemRole.PRIMARY_OWNER.name())) {
                    this.groupService.updateApiPrimaryOwner(this.group, null);
                } else if (roleName.equals(SystemRole.PRIMARY_OWNER.name())) {
                    this.groupService.updateApiPrimaryOwner(this.group, updatedMembership.getId());
                }
            }
            if ((applicationRoleEntity = (RoleEntity)roleEntities.get(RoleScope.APPLICATION)) != null && !applicationRoleEntity.equals((Object)previousApplicationRole)) {
                String roleName = this.getRoleName(RoleScope.APPLICATION, applicationRoleEntity, groupEntity, GroupEntity::isLockApplicationRole, hasPermission);
                this.updateRole(RoleScope.APPLICATION, roleName, previousApplicationRole, membership, executionContext);
            }
            if ((integrationRoleEntity = (RoleEntity)roleEntities.get(RoleScope.INTEGRATION)) != null && !integrationRoleEntity.equals((Object)previousIntegrationRole)) {
                String roleName = this.getRoleName(RoleScope.INTEGRATION, integrationRoleEntity, groupEntity, e -> true, hasPermission);
                this.updateRole(RoleScope.INTEGRATION, roleName, previousIntegrationRole, membership, executionContext);
            }
            if ((groupRoleEntity = (RoleEntity)roleEntities.get(RoleScope.GROUP)) != null && !groupRoleEntity.equals((Object)previousGroupRole)) {
                this.updateRole(RoleScope.GROUP, groupRoleEntity.getName(), previousGroupRole, membership, executionContext);
            }
            String membershipId = membership.getId();
            this.deleteIfNewAndPreviousRoleNull(apiRoleEntity, previousApiRole, membershipId);
            this.deleteIfNewAndPreviousRoleNull(applicationRoleEntity, previousApplicationRole, membershipId);
            this.deleteIfNewAndPreviousRoleNull(integrationRoleEntity, previousIntegrationRole, membershipId);
            this.deleteIfNewAndPreviousRoleNull(groupRoleEntity, previousGroupRole, membershipId);
            if (previousApiRole != null || previousApplicationRole != null || previousGroupRole != null || previousIntegrationRole != null || updatedMembership == null) continue;
            UserEntity userEntity = this.userService.findById(executionContext, updatedMembership.getId());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("group", groupEntity);
            params.put("user", userEntity);
            this.notifierService.trigger(executionContext, PortalHook.GROUP_INVITATION, params);
        }
        this.eventManager.publishEvent((Enum)ApplicationAlertEventType.APPLICATION_MEMBERSHIP_UPDATE, (Object)new ApplicationAlertMembershipEvent(executionContext.getOrganizationId(), Collections.emptySet(), Collections.singleton(this.group)));
        return Response.ok().build();
    }

    private void deleteIfNewAndPreviousRoleNull(RoleEntity newRole, RoleEntity previousRole, String membershipId) {
        if (newRole == null && previousRole != null) {
            this.membershipService.removeRole(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, membershipId, previousRole.getId());
        }
    }

    String getRoleName(RoleScope scope, RoleEntity roleEntity, GroupEntity groupEntity, Predicate<GroupEntity> isLocked, boolean hasPermission) {
        String roleName = roleEntity.getName();
        if (!hasPermission && isLocked.test(groupEntity)) {
            if (groupEntity.getRoles() != null && !groupEntity.getRoles().isEmpty()) {
                roleName = (String)groupEntity.getRoles().get(scope);
            } else {
                List defaultRoles = this.roleService.findDefaultRoleByScopes(GraviteeContext.getCurrentOrganization(), new RoleScope[]{scope});
                if (defaultRoles != null && !defaultRoles.isEmpty()) {
                    roleName = ((RoleEntity)defaultRoles.get(0)).getName();
                }
            }
        }
        return roleName;
    }

    MemberEntity updateRole(RoleScope scope, String newRoleName, RoleEntity previousRole, GroupMembership membership, ExecutionContext executionContext) {
        MemberEntity updatedMembership = this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.GROUP, this.group), new MembershipService.MembershipMember(membership.getId(), membership.getReference(), MembershipMemberType.USER), new MembershipService.MembershipRole(scope, newRoleName));
        if (previousRole != null) {
            this.membershipService.removeRole(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, updatedMembership.getId(), previousRole.getId());
        }
        return updatedMembership;
    }

    @Path(value="{member}")
    public GroupMemberResource groupMemberResource() {
        return (GroupMemberResource)this.resourceContext.getResource(GroupMemberResource.class);
    }
}

