/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ThemeResource;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.theme.ThemeType;
import io.gravitee.rest.api.model.theme.portal.NewThemeEntity;
import io.gravitee.rest.api.model.theme.portal.ThemeEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ThemeService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ThemeTypeNotSupportedException;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;

@Tag(name="Themes")
public class ThemesResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ThemeService themeService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.CREATE})})
    public ThemeEntity createTheme(@Valid @NotNull NewThemeEntity theme) {
        if (!ThemeType.PORTAL.equals((Object)theme.getType())) {
            throw new ThemeTypeNotSupportedException(null, theme.getType());
        }
        return this.themeService.createPortalTheme(GraviteeContext.getExecutionContext(), theme);
    }

    @Path(value="/current")
    @GET
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.READ})})
    public ThemeEntity getCurrentTheme() {
        return this.themeService.findOrCreateDefaultPortalTheme(GraviteeContext.getExecutionContext());
    }

    @Path(value="{themeId}")
    public ThemeResource getThemeResource() {
        return (ThemeResource)this.resourceContext.getResource(ThemeResource.class);
    }
}

