/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.NewTokenEntity;
import io.gravitee.rest.api.model.TokenEntity;
import io.gravitee.rest.api.service.TokenService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.TokenNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Tag(name="User Tokens")
public class TokensResource
extends AbstractResource {
    @Inject
    private TokenService tokenService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List user's personal tokens")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User's personal tokens", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TokenEntity.class)))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<TokenEntity> getTokens() {
        return this.tokenService.findByUser(this.getAuthenticatedUser()).stream().sorted(Comparator.comparing(TokenEntity::getCreatedAt)).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a personal token")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="A new personal token", content={@Content(mediaType="application/json", schema=@Schema(implementation=TokenEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public TokenEntity createTokens(@Valid @NotNull NewTokenEntity token) {
        return this.tokenService.create(GraviteeContext.getExecutionContext(), token, this.getAuthenticatedUser());
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Revoke all user's personal tokens")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User's personal tokens revoked"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void revokeAllTokens() {
        this.tokenService.revokeByUser(GraviteeContext.getExecutionContext(), this.getAuthenticatedUser());
    }

    @Path(value="{token}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Revoke a single user's personal tokens")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User's personal token revoked"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void revokeToken(@PathParam(value="token") String tokenId) {
        if (!this.tokenService.tokenExistsForUser(tokenId, this.getAuthenticatedUserOrNull())) {
            throw new TokenNotFoundException(tokenId);
        }
        this.tokenService.revoke(GraviteeContext.getExecutionContext(), tokenId);
    }
}

