/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.CustomUserFieldEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.CustomUserFieldService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.CustomUserFieldException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;

@Tag(name="Custom User Fields")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomUserFieldsResource
extends AbstractResource {
    @Context
    private UriInfo uriInfo;
    @Inject
    private CustomUserFieldService fieldService;

    @GET
    @Operation(summary="List All Custom User Fields", description="User must have the CUSTOM_USER_FIELDS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Custom User Field deleted", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CustomUserFieldEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCustomUserFields() {
        List fields = this.fieldService.listAllFields(GraviteeContext.getExecutionContext());
        return Response.ok().entity((Object)fields).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_CUSTOM_USER_FIELDS, acls={RolePermissionAction.CREATE})})
    @Operation(summary="Create a Custom User Field", description="User must have the CUSTOM_USER_FIELDS[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Custom User Field Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUserFieldEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createCustomUserField(@Valid CustomUserFieldEntity newCustomUserFieldEntity) {
        CustomUserFieldEntity newField = this.fieldService.create(GraviteeContext.getExecutionContext(), newCustomUserFieldEntity);
        if (newField != null) {
            return Response.created((URI)URI.create(this.uriInfo.getPath() + "/" + newField.getKey())).entity((Object)newField).build();
        }
        return Response.serverError().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{key}")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_CUSTOM_USER_FIELDS, acls={RolePermissionAction.UPDATE})})
    @Operation(summary="Update a Custom User Field", description="User must have the CUSTOM_USER_FIELDS[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Custom User Field updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUserFieldEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateCustomUserField(@PathParam(value="key") String key, @Valid CustomUserFieldEntity toUpdateFieldEntity) {
        if (toUpdateFieldEntity == null || !key.toLowerCase().equals(toUpdateFieldEntity.getKey().toLowerCase())) {
            throw new CustomUserFieldException(key, "update");
        }
        CustomUserFieldEntity updatedField = this.fieldService.update(GraviteeContext.getExecutionContext(), toUpdateFieldEntity);
        if (updatedField != null) {
            return Response.ok().entity((Object)updatedField).build();
        }
        return Response.serverError().build();
    }

    @DELETE
    @Path(value="{key}")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_CUSTOM_USER_FIELDS, acls={RolePermissionAction.DELETE})})
    @Operation(summary="Delete a Custom User Field", description="User must have the CUSTOM_USER_FIELDS[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Custom User Field deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteCustomUserField(@PathParam(value="key") String key) {
        this.fieldService.delete(GraviteeContext.getExecutionContext(), key);
        return Response.noContent().build();
    }
}

