/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.wrapper.ApplicationRequestItemSearchLogResponse;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.LogsParam;
import io.gravitee.rest.api.model.analytics.query.LogQuery;
import io.gravitee.rest.api.model.log.ApplicationRequest;
import io.gravitee.rest.api.model.log.ApplicationRequestItem;
import io.gravitee.rest.api.model.log.SearchLogResponse;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.LogsService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@Tag(name="Application Logs")
public class ApplicationLogsResource
extends AbstractResource {
    @Inject
    private LogsService logsService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get application logs")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application logs", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationRequestItemSearchLogResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_LOG, acls={RolePermissionAction.READ})})
    public SearchLogResponse<ApplicationRequestItem> getApplicationLogs(@BeanParam LogsParam param) {
        param.validate();
        LogQuery logQuery = new LogQuery();
        logQuery.setQuery(param.getQuery());
        logQuery.setPage(param.getPage());
        logQuery.setSize(param.getSize());
        logQuery.setFrom(param.getFrom());
        logQuery.setTo(param.getTo());
        logQuery.setField(param.getField());
        logQuery.setOrder(param.isOrder());
        return this.logsService.findByApplication(GraviteeContext.getExecutionContext(), this.application, logQuery);
    }

    @GET
    @Path(value="/{log}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a specific log")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Single log", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationRequest.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_LOG, acls={RolePermissionAction.READ})})
    public ApplicationRequest getApplicationLog(@PathParam(value="log") String logId, @QueryParam(value="timestamp") Long timestamp) {
        return this.logsService.findApplicationLog(GraviteeContext.getExecutionContext(), this.application, logId, timestamp);
    }

    @GET
    @Path(value="export")
    @Produces(value={"text/csv"})
    @Operation(summary="Export application logs as CSV")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application logs as CSV", content={@Content(mediaType="text/csv", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_LOG, acls={RolePermissionAction.READ})})
    public Response exportApplicationLogsAsCSV(@BeanParam LogsParam param) {
        SearchLogResponse<ApplicationRequestItem> searchLogResponse = this.getApplicationLogs(param);
        return Response.ok((Object)this.logsService.exportAsCsv(GraviteeContext.getExecutionContext(), searchLogResponse)).header("Content-Disposition", (Object)String.format("attachment;filename=logs-%s-%s.csv", this.application, System.currentTimeMillis())).build();
    }
}

