/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.model.Event;
import io.gravitee.rest.api.management.rest.model.wrapper.EventEntityPage;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.EventSearchParam;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Tag(name="Platform Events")
public class PlatformEventsResource
extends AbstractResource {
    @Inject
    private EventService eventService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List platform events", description="User must have the MANAGEMENT_PLATFORM[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Platform events", content={@Content(mediaType="application/json", schema=@Schema(implementation=EventEntityPage.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public EventEntityPage getPlatformEvents(@BeanParam EventSearchParam eventSearchParam) {
        eventSearchParam.validate();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (eventSearchParam.getApiIdsParam() != null && !eventSearchParam.getApiIdsParam().isEmpty()) {
            properties.put(Event.EventProperties.API_ID.getValue(), eventSearchParam.getApiIdsParam());
        } else if (!this.isAdmin()) {
            properties.put(Event.EventProperties.API_ID.getValue(), this.apiAuthorizationService.findIdsByUser(executionContext, this.getAuthenticatedUser(), true).stream().filter(apiId -> this.permissionService.hasPermission(executionContext, RolePermission.API_ANALYTICS, apiId, new RolePermissionAction[]{RolePermissionAction.READ})).collect(Collectors.joining(",")));
        }
        Page events = this.eventService.search(executionContext, (List)eventSearchParam.getEventTypeListParam(), properties, eventSearchParam.getFrom(), eventSearchParam.getTo(), eventSearchParam.getPage().intValue(), eventSearchParam.getSize().intValue(), Collections.singletonList(GraviteeContext.getCurrentEnvironment()));
        events.getContent().forEach(event -> {
            Map properties1 = event.getProperties();
            if (properties1 != null && properties1.containsKey(Event.EventProperties.API_ID.getValue())) {
                event.setPayload(null);
                String apiId = (String)properties1.get(Event.EventProperties.API_ID.getValue());
                try {
                    GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, apiId);
                    properties1.put("api_name", genericApiEntity.getName());
                    properties1.put("api_version", genericApiEntity.getApiVersion());
                }
                catch (ApiNotFoundException anfe) {
                    properties1.put("deleted", Boolean.TRUE.toString());
                    properties1.put("api_name", "Deleted API");
                }
            }
        });
        return new EventEntityPage((Page<EventEntity>)events);
    }
}

