/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.swagger;

import io.swagger.v3.jaxrs2.ReaderListener;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.integration.api.OpenApiReader;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeMap;

@OpenAPIDefinition
public class GraviteeApiDefinition
implements ReaderListener {
    public static final String TOKEN_AUTH_SCHEME = "gravitee-auth";

    public void beforeScan(OpenApiReader reader, OpenAPI openAPI) {
    }

    public void afterScan(OpenApiReader reader, OpenAPI openAPI) {
        TreeMap tags = new TreeMap();
        if (openAPI.getTags() != null) {
            openAPI.getTags().forEach(tag -> tags.put(tag.getName(), tag));
        }
        openAPI.getPaths().values().stream().map(PathItem::readOperations).flatMap(Collection::stream).map(Operation::getTags).filter(Objects::nonNull).flatMap(Collection::stream).forEach(tag -> tags.computeIfAbsent(tag, s -> new Tag().name(s)));
        openAPI.tags(new ArrayList(tags.values()));
        Paths paths = new Paths();
        paths.putAll(new TreeMap(openAPI.getPaths()));
        openAPI.setPaths(paths);
        Components components = new Components();
        components.schemas(new TreeMap(openAPI.getComponents().getSchemas()));
        components.addSecuritySchemes(TOKEN_AUTH_SCHEME, new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic"));
        openAPI.components(components);
        openAPI.addSecurityItem(new SecurityRequirement().addList(TOKEN_AUTH_SCHEME));
    }
}

