/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.MetadataEntity;
import io.gravitee.rest.api.model.NewMetadataEntity;
import io.gravitee.rest.api.model.UpdateMetadataEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.MetadataService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;

@Tag(name="Metadata")
public class MetadataResource
extends AbstractResource {
    @Inject
    private MetadataService metadataService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve the list of platform metadata", description="User must have the PORTAL_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of environment metadata", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MetadataEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_METADATA, acls={RolePermissionAction.READ})})
    public List<MetadataEntity> getMetadatas() {
        return this.metadataService.findByReferenceTypeAndReferenceId(MetadataReferenceType.ENVIRONMENT, GraviteeContext.getExecutionContext().getEnvironmentId());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a platform metadata", description="User must have the PORTAL_METADATA[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Metadata successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetadataEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_METADATA, acls={RolePermissionAction.CREATE})})
    public MetadataEntity createMetadata(@Valid @NotNull NewMetadataEntity metadata) {
        return this.metadataService.create(GraviteeContext.getExecutionContext(), metadata);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a platform metadata", description="User must have the PORTAL_METADATA[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated metadata", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetadataEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_METADATA, acls={RolePermissionAction.UPDATE})})
    public MetadataEntity updateMetadata(@Valid @NotNull UpdateMetadataEntity metadata) {
        return this.metadataService.update(GraviteeContext.getExecutionContext(), metadata);
    }

    @Path(value="{metadata}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete a platform metadata", description="User must have the PORTAL_METADATA[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Metadata successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_METADATA, acls={RolePermissionAction.DELETE})})
    public void deleteMetadata(@PathParam(value="metadata") String metadata) {
        this.metadataService.delete(GraviteeContext.getExecutionContext(), metadata);
    }
}

