/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import com.fasterxml.jackson.databind.JavaType;
import io.gravitee.rest.api.management.rest.mapper.ObjectMapperResolver;
import io.gravitee.rest.api.management.rest.provider.BadRequestExceptionMapper;
import io.gravitee.rest.api.management.rest.provider.ByteArrayOutputStreamWriter;
import io.gravitee.rest.api.management.rest.provider.ConstraintValidationExceptionMapper;
import io.gravitee.rest.api.management.rest.provider.EnumParamConverterProvider;
import io.gravitee.rest.api.management.rest.provider.ManagementExceptionMapper;
import io.gravitee.rest.api.management.rest.provider.NotAllowedDomainExceptionMapper;
import io.gravitee.rest.api.management.rest.provider.NotAllowedExceptionMapper;
import io.gravitee.rest.api.management.rest.provider.NotFoundDomainExceptionMapper;
import io.gravitee.rest.api.management.rest.provider.NotFoundExceptionMapper;
import io.gravitee.rest.api.management.rest.provider.PayloadInputBodyReader;
import io.gravitee.rest.api.management.rest.provider.TechnicalDomainExceptionMapper;
import io.gravitee.rest.api.management.rest.provider.ThrowableMapper;
import io.gravitee.rest.api.management.rest.provider.UnrecognizedPropertyExceptionMapper;
import io.gravitee.rest.api.management.rest.provider.ValidationDomainExceptionMapper;
import io.gravitee.rest.api.management.rest.resource.auth.CockpitAuthenticationResource;
import io.gravitee.rest.api.management.rest.resource.auth.ExternalAuthenticationResource;
import io.gravitee.rest.api.management.rest.resource.organization.OrganizationsResource;
import io.gravitee.rest.api.management.rest.resource.organization.V1OrganizationsResource;
import io.gravitee.rest.api.management.rest.resource.swagger.OpenAPIResource;
import io.gravitee.rest.api.rest.filter.GraviteeContextResponseFilter;
import io.gravitee.rest.api.rest.filter.GraviteeLicenseFilter;
import io.gravitee.rest.api.rest.filter.MaintenanceFilter;
import io.gravitee.rest.api.rest.filter.PermissionsFilter;
import io.gravitee.rest.api.rest.filter.SecurityContextFilter;
import io.gravitee.rest.api.rest.filter.UriBuilderRequestFilter;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Iterator;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class GraviteeManagementApplication
extends ResourceConfig {
    @Inject
    public GraviteeManagementApplication() {
        ModelConverters.getInstance().addConverter(new ModelConverter(){

            public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
                Class cls;
                JavaType jType = Json.mapper().constructType(type);
                if (jType != null && Date.class.isAssignableFrom(cls = jType.getRawClass())) {
                    return new LongProperty();
                }
                return chain.hasNext() ? chain.next().resolveProperty(type, context, annotations, chain) : null;
            }

            public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
                return chain.next().resolve(type, context, chain);
            }
        });
        this.register(OrganizationsResource.class);
        this.register(V1OrganizationsResource.class);
        this.register(CockpitAuthenticationResource.class);
        this.register(ExternalAuthenticationResource.class);
        this.register(MultiPartFeature.class);
        this.register(PayloadInputBodyReader.class);
        this.register(ObjectMapperResolver.class);
        this.register(ManagementExceptionMapper.class);
        this.register(ConstraintValidationExceptionMapper.class);
        this.register(UnrecognizedPropertyExceptionMapper.class);
        this.register(ThrowableMapper.class);
        this.register(NotFoundExceptionMapper.class);
        this.register(NotAllowedExceptionMapper.class);
        this.register(BadRequestExceptionMapper.class);
        this.register(EnumParamConverterProvider.class);
        this.register(ValidationDomainExceptionMapper.class);
        this.register(NotAllowedDomainExceptionMapper.class);
        this.register(NotFoundDomainExceptionMapper.class);
        this.register(TechnicalDomainExceptionMapper.class);
        this.register(SecurityContextFilter.class);
        this.register(PermissionsFilter.class);
        this.register(GraviteeLicenseFilter.class);
        this.register(GraviteeContextResponseFilter.class);
        this.register(UriBuilderRequestFilter.class);
        this.register(MaintenanceFilter.class);
        this.register(ByteArrayOutputStreamWriter.class);
        this.register(JacksonFeature.class);
        this.register(OpenAPIResource.class);
        this.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", true);
        this.property("jersey.config.beanValidation.disable.validateOnExecutableCheck.server", true);
    }
}

