/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.core.subscription.use_case.CloseSubscriptionUseCase;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscriptionApiKeysResource;
import io.gravitee.rest.api.model.SubscriptionConsumerStatus;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.UpdateSubscriptionConfigurationEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.sql.Date;

@Tag(name="Application Subscriptions")
public class ApplicationSubscriptionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private CloseSubscriptionUseCase closeSubscriptionUsecase;
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private PlanSearchService planSearchService;
    @Inject
    private UserService userService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;
    @PathParam(value="subscription")
    @Parameter(name="subscription")
    private String subscription;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get subscription information", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Subscription information", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Subscription getApplicationSubscription() {
        return this.convert(GraviteeContext.getExecutionContext(), this.subscriptionService.findById(this.subscription));
    }

    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="Close the subscription", description="User must have the APPLICATION_SUBSCRIPTION[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Subscription has been closed successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response closeApplicationSubscription() {
        io.gravitee.rest.api.model.SubscriptionEntity subscriptionEntity = this.subscriptionService.findById(this.subscription);
        if (subscriptionEntity.getApplication().equals(this.application)) {
            ExecutionContext executionContext = GraviteeContext.getExecutionContext();
            UserDetails user = this.getAuthenticatedUserDetails();
            CloseSubscriptionUseCase.Output result = this.closeSubscriptionUsecase.execute(CloseSubscriptionUseCase.Input.builder().subscriptionId(this.subscription).applicationId(this.application).auditInfo(AuditInfo.builder().organizationId(executionContext.getOrganizationId()).environmentId(executionContext.getEnvironmentId()).actor(AuditActor.builder().userId(user.getUsername()).userSource(user.getSource()).userSourceId(user.getSourceId()).build()).build()).build());
            return Response.ok((Object)this.convert(executionContext, result.subscription())).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Path(value="apikeys")
    public ApplicationSubscriptionApiKeysResource getApiSubscriptionApiKeysResourceResource() {
        return (ApplicationSubscriptionApiKeysResource)this.resourceContext.getResource(ApplicationSubscriptionApiKeysResource.class);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a subscription configuration", description="User must have the APPLICATION_SUBSCRIPTION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Update a subscription configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=io.gravitee.rest.api.model.SubscriptionEntity.class))}), @ApiResponse(responseCode="404", description="Subscription not found"), @ApiResponse(responseCode="400", description="Subscription not updatable, or bad subscription configuration format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response updateApplicationSubscription(@Valid @NotNull UpdateSubscriptionConfigurationEntity updateSubscriptionConfigurationEntity) {
        updateSubscriptionConfigurationEntity.setSubscriptionId(this.subscription);
        io.gravitee.rest.api.model.SubscriptionEntity updatedSubscription = this.subscriptionService.update(GraviteeContext.getExecutionContext(), updateSubscriptionConfigurationEntity);
        return Response.ok((Object)updatedSubscription).build();
    }

    @POST
    @Path(value="/_changeConsumerStatus")
    @Produces(value={"application/json"})
    @Operation(summary="Change the status of a subscription", description="User must have the APPLICATION_SUBSCRIPTION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Subscription status successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Status changes not authorized"), @ApiResponse(responseCode="404", description="API subscription does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response changeSubscriptionConsumerStatus(@Parameter(required=true, schema=@Schema(allowableValues={"STARTED", "STOPPED"})) @QueryParam(value="status") SubscriptionConsumerStatus subscriptionConsumerStatus) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (subscriptionConsumerStatus == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        switch (subscriptionConsumerStatus) {
            case STARTED: {
                io.gravitee.rest.api.model.SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.resumeConsumer(executionContext, this.subscription);
                return Response.ok((Object)this.convert(executionContext, updatedSubscriptionEntity)).build();
            }
            case STOPPED: {
                io.gravitee.rest.api.model.SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.pauseConsumer(executionContext, this.subscription);
                return Response.ok((Object)this.convert(executionContext, updatedSubscriptionEntity)).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    private Subscription convert(ExecutionContext executionContext, io.gravitee.rest.api.model.SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setConsumerStatus(subscriptionEntity.getConsumerStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(executionContext, subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        subscription.setPlan(this.fetchPlan(executionContext, subscriptionEntity.getPlan()));
        subscription.setApi(this.fetchApi(executionContext, subscriptionEntity.getApi()));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        subscription.setPausedAt(subscriptionEntity.getPausedAt());
        subscription.setConsumerPausedAt(subscriptionEntity.getConsumerPausedAt());
        return subscription;
    }

    private Subscription convert(ExecutionContext executionContext, SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(Date.from(subscriptionEntity.getCreatedAt().toInstant()));
        subscription.setUpdatedAt(Date.from(subscriptionEntity.getUpdatedAt().toInstant()));
        subscription.setStartingAt(subscriptionEntity.getStartingAt() != null ? Date.from(subscriptionEntity.getStartingAt().toInstant()) : null);
        subscription.setEndingAt(subscriptionEntity.getEndingAt() != null ? Date.from(subscriptionEntity.getEndingAt().toInstant()) : null);
        subscription.setClosedAt(subscriptionEntity.getClosedAt() != null ? Date.from(subscriptionEntity.getClosedAt().toInstant()) : null);
        subscription.setPausedAt(subscriptionEntity.getPausedAt() != null ? Date.from(subscriptionEntity.getPausedAt().toInstant()) : null);
        subscription.setConsumerPausedAt(subscriptionEntity.getConsumerPausedAt() != null ? Date.from(subscriptionEntity.getConsumerPausedAt().toInstant()) : null);
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt() != null ? Date.from(subscriptionEntity.getProcessedAt().toInstant()) : null);
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setRequest(subscriptionEntity.getRequestMessage());
        subscription.setReason(subscriptionEntity.getReasonMessage());
        subscription.setStatus(switch (subscriptionEntity.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriptionEntity.Status.PENDING -> SubscriptionStatus.PENDING;
            case SubscriptionEntity.Status.REJECTED -> SubscriptionStatus.REJECTED;
            case SubscriptionEntity.Status.ACCEPTED -> SubscriptionStatus.ACCEPTED;
            case SubscriptionEntity.Status.CLOSED -> SubscriptionStatus.CLOSED;
            case SubscriptionEntity.Status.PAUSED -> SubscriptionStatus.PAUSED;
        });
        subscription.setConsumerStatus(switch (subscriptionEntity.getConsumerStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriptionEntity.ConsumerStatus.STARTED -> SubscriptionConsumerStatus.STARTED;
            case SubscriptionEntity.ConsumerStatus.STOPPED -> SubscriptionConsumerStatus.STOPPED;
            case SubscriptionEntity.ConsumerStatus.FAILURE -> SubscriptionConsumerStatus.FAILURE;
        });
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(executionContext, subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        subscription.setPlan(this.fetchPlan(executionContext, subscriptionEntity.getPlanId()));
        subscription.setApi(this.fetchApi(executionContext, subscriptionEntity.getApiId()));
        return subscription;
    }

    private Subscription.Plan fetchPlan(ExecutionContext executionContext, String planId) {
        GenericPlanEntity genericPlan = this.planSearchService.findById(executionContext, planId);
        Subscription.Plan plan = new Subscription.Plan(genericPlan.getId(), genericPlan.getName());
        if (genericPlan.getPlanSecurity() != null) {
            plan.setSecurity(PlanSecurityType.valueOfLabel((String)genericPlan.getPlanSecurity().getType()).name());
        }
        return plan;
    }

    private Subscription.Api fetchApi(ExecutionContext executionContext, String apiId) {
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, apiId);
        return new Subscription.Api(genericApiEntity.getId(), genericApiEntity.getName(), genericApiEntity.getApiVersion(), new Subscription.User(genericApiEntity.getPrimaryOwner().getId(), genericApiEntity.getPrimaryOwner().getDisplayName()));
    }
}

