/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.model.api.DefinitionContextEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ApiDefinitionContextService;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;

public class ApiDefinitionContextResource {
    @PathParam(value="api")
    private String apiId;
    private final ApiDefinitionContextService definitionContextService;

    @Inject
    public ApiDefinitionContextResource(ApiDefinitionContextService definitionContextService) {
        this.definitionContextService = definitionContextService;
    }

    @PUT
    @Hidden
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateDefinitionContext(@Valid @NotNull DefinitionContextEntity definitionContext) {
        this.definitionContextService.setDefinitionContext(this.apiId, definitionContext);
        return Response.ok().build();
    }
}

