/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.model.TokenEntity;
import io.gravitee.rest.api.management.rest.resource.auth.AbstractAuthenticationResource;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.exceptions.InvalidTokenException;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import javax.inject.Singleton;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Singleton
@Path(value="/redirect")
public class PortalRedirectResource
extends AbstractAuthenticationResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalRedirectResource.class);
    private static final String PROPERTY_HTTP_API_PORTAL_PROXY_PATH = "installation.api.proxyPath.portal";
    private static final String PROPERTY_HTTP_API_PORTAL_ENTRYPOINT = "http.api.portal.entrypoint";
    @Autowired
    private InstallationAccessQueryService installationAccessQueryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Response redirectToPortal(@Context HttpServletRequest httpServletRequest) {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            UserDetails userDetails = (UserDetails)authentication.getPrincipal();
            UserEntity user = this.userService.findById(GraviteeContext.getExecutionContext(), userDetails.getUsername());
            TokenEntity tokenEntity = this.generateToken(user, 30);
            String environmentId = GraviteeContext.getCurrentEnvironment() != null ? GraviteeContext.getCurrentEnvironment() : GraviteeContext.getDefaultEnvironment();
            String url = this.installationAccessQueryService.getPortalAPIUrl(environmentId);
            if (url == null) {
                ServletServerHttpRequest request = new ServletServerHttpRequest(httpServletRequest);
                UriComponents uriComponents = UriComponentsBuilder.fromHttpRequest((HttpRequest)request).replacePath(this.getPortalProxyPath()).replaceQuery(null).build();
                url = uriComponents.toUriString();
            }
            Response response = Response.temporaryRedirect((URI)new URI("%s/environments/%s/auth/console?token=%s".formatted(url, environmentId, tokenEntity.getToken()))).build();
            return response;
        }
        catch (InvalidTokenException | UserNotFoundException e) {
            log.error("Authentication failed", e);
            Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            return response;
        }
        catch (Exception e) {
            log.error("Error occurred when trying to log user using external authentication provider.", (Throwable)e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            GraviteeContext.cleanContext();
        }
    }

    private String getPortalProxyPath() {
        String entrypoint = this.environment.getProperty(PROPERTY_HTTP_API_PORTAL_ENTRYPOINT, "/portal");
        return this.environment.getProperty(PROPERTY_HTTP_API_PORTAL_PROXY_PATH, entrypoint);
    }
}

