/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.ApplicationMembership;
import io.gravitee.rest.api.management.rest.model.TransferOwnership;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipListItem;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.permissions.ApplicationPermission;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.SinglePrimaryOwnerException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Tag(name="Application Memberships")
public class ApplicationMembersResource
extends AbstractResource {
    @Inject
    private MembershipService membershipService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private UserService userService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @GET
    @Path(value="/permissions")
    @Produces(value={"application/json"})
    @Operation(summary="Get application members", description="User must have the APPLICATION_MEMBER permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application member's permissions", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MemberEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApplicationMemberPermissions() {
        Map<String, char[]> permissions = new HashMap();
        if (this.isAuthenticated()) {
            String username = this.getAuthenticatedUser();
            ExecutionContext executionContext = GraviteeContext.getExecutionContext();
            ApplicationEntity applicationEntity = this.applicationService.findById(executionContext, this.application);
            if (this.isAdmin()) {
                char[] rights = new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()};
                for (ApplicationPermission perm : ApplicationPermission.values()) {
                    permissions.put(perm.getName(), rights);
                }
            } else {
                permissions = this.membershipService.getUserMemberPermissions(executionContext, applicationEntity, username);
            }
        }
        return Response.ok(permissions).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List application members", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application successfully deleted", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MembershipListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.READ})})
    public List<MembershipListItem> getApplicationMembers() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        this.applicationService.findById(executionContext, this.application);
        return this.membershipService.getMembersByReference(executionContext, MembershipReferenceType.APPLICATION, this.application).stream().map(MembershipListItem::new).sorted(Comparator.comparing(MembershipListItem::getId)).collect(Collectors.toList());
    }

    @POST
    @Operation(summary="Add or update an application member", description="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Member has been added or updated successfully"), @ApiResponse(responseCode="400", description="Membership parameter is not valid"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response addOrUpdateApplicationMember(@Valid @NotNull ApplicationMembership applicationMembership) {
        MemberEntity userMember;
        if (SystemRole.PRIMARY_OWNER.name().equals(applicationMembership.getRole())) {
            throw new SinglePrimaryOwnerException(RoleScope.APPLICATION);
        }
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        this.applicationService.findById(executionContext, this.application);
        MembershipService.MembershipReference reference = new MembershipService.MembershipReference(MembershipReferenceType.APPLICATION, this.application);
        MembershipService.MembershipMember member = new MembershipService.MembershipMember(applicationMembership.getId(), applicationMembership.getReference(), MembershipMemberType.USER);
        MembershipService.MembershipRole role = new MembershipService.MembershipRole(RoleScope.APPLICATION, applicationMembership.getRole());
        MemberEntity membership = null;
        if (applicationMembership.getId() != null && (userMember = this.membershipService.getUserMember(executionContext, MembershipReferenceType.APPLICATION, this.application, applicationMembership.getId())) != null && userMember.getRoles() != null && !userMember.getRoles().isEmpty()) {
            membership = this.membershipService.updateRoleToMemberOnReference(executionContext, reference, member, role);
        }
        if (membership == null) {
            this.membershipService.addRoleToMemberOnReference(executionContext, reference, member, role);
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Operation(summary="Remove an application member", description="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Member has been removed successfully"), @ApiResponse(responseCode="400", description="User does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.DELETE})})
    public Response deleteApplicationMember(@Parameter(name="user", required=true) @NotNull @QueryParam(value="user") String userId) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        this.applicationService.findById(executionContext, this.application);
        try {
            this.userService.findById(executionContext, userId);
        }
        catch (UserNotFoundException unfe) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)unfe.getMessage()).build();
        }
        this.membershipService.deleteReferenceMember(executionContext, MembershipReferenceType.APPLICATION, this.application, MembershipMemberType.USER, userId);
        return Response.ok().build();
    }

    @POST
    @Path(value="transfer_ownership")
    @Operation(summary="Transfer the ownership of the APPLICATION", description="User must have the TRANSFER_OWNERSHIP permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ownership has been transferred successfully"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response transferApplicationOwnership(@Valid @NotNull TransferOwnership transferOwnership) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ArrayList newRoles = new ArrayList();
        this.roleService.findByScopeAndName(RoleScope.APPLICATION, transferOwnership.getPoRole(), executionContext.getOrganizationId()).ifPresent(newRoles::add);
        this.applicationService.findById(executionContext, this.application);
        this.membershipService.transferApplicationOwnership(executionContext, this.application, new MembershipService.MembershipMember(transferOwnership.getId(), transferOwnership.getReference(), MembershipMemberType.USER), newRoles);
        return Response.ok().build();
    }
}

