/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ThemeResource;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.theme.NewThemeEntity;
import io.gravitee.rest.api.model.theme.ThemeEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ThemeService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;

@Tag(name="Themes")
public class ThemesResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ThemeService themeService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.CREATE})})
    public ThemeEntity createTheme(@Valid @NotNull NewThemeEntity theme) {
        return this.themeService.create(GraviteeContext.getExecutionContext(), theme);
    }

    @Path(value="/current")
    @GET
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.READ})})
    public ThemeEntity getCurrentTheme() {
        return this.themeService.findOrCreateDefault(GraviteeContext.getExecutionContext());
    }

    @Path(value="{themeId}")
    public ThemeResource getThemeResource() {
        return (ThemeResource)this.resourceContext.getResource(ThemeResource.class);
    }
}

